/*
 * Decompiled with CFR 0.152.
 */
package net.brnbrd.delightful.data.gen;

import java.util.List;
import net.brnbrd.delightful.Util;
import net.brnbrd.delightful.common.item.DelightfulItems;
import net.brnbrd.delightful.common.item.knife.DelightfulKnifeItem;
import net.brnbrd.delightful.common.item.knife.Knives;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class DelightfulItemModelProvider
extends ItemModelProvider {
    private static final List<ResourceLocation> FLAT_BLOCKS = List.of(DelightfulItems.WILD_SALMONBERRIES.getId(), DelightfulItems.STUFFED_CANTALOUPE_BLOCK.getId());
    private static final List<ResourceLocation> ITEM_BLOCKS = List.of(DelightfulItems.SALMONBERRY_PIE.getId(), DelightfulItems.BAKLAVA.getId());
    private static final List<ResourceLocation> EMISSIVE = List.of(Knives.FIERY.getId());

    public DelightfulItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "delightful", existingFileHelper);
    }

    protected void registerModels() {
        for (RegistryObject entry : DelightfulItems.ITEMS.getEntries()) {
            ResourceLocation id = entry.getId();
            if (EMISSIVE.contains(id)) {
                this.emissive(id);
                continue;
            }
            if (entry.get() instanceof DelightfulKnifeItem) {
                this.handheld(id);
                continue;
            }
            if (FLAT_BLOCKS.contains(id)) {
                this.flatBlock(id);
                continue;
            }
            if (entry.get() instanceof BlockItem && !(entry.get() instanceof ItemNameBlockItem) && !ITEM_BLOCKS.contains(id)) {
                this.withExistingParent(id.m_135815_(), Util.rl(this.modid, "block/" + id.m_135815_()));
                continue;
            }
            this.basicItem(id);
        }
    }

    public void flatBlock(ResourceLocation id) {
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(id.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", new ResourceLocation(id.m_135827_(), "block/" + id.m_135815_()));
    }

    public void handheld(ResourceLocation item) {
        ((ItemModelBuilder)this.withExistingParent(item.m_135815_(), "item/handheld")).texture("layer0", Util.rl("delightful", "item/" + item.m_135815_()));
    }

    public void emissive(ResourceLocation item) {
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.m_135815_(), "item/handheld")).texture("layer0", Util.rl("delightful", "item/" + item.m_135815_()))).guiLight(BlockModel.GuiLight.FRONT);
    }
}

