/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.fog.client.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.architectury.event.events.client.ClientCommandRegistrationEvent;
import dev.imb11.fog.client.FogManager;
import dev.imb11.fog.client.util.color.Color;
import dev.imb11.fog.config.FogConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FogClientCommands {
    public static void register() {
        ClientCommandRegistrationEvent.EVENT.register((dispatcher, context) -> {
            LiteralArgumentBuilder fogNode = ClientCommandRegistrationEvent.literal((String)"fog");
            fogNode = (LiteralArgumentBuilder)fogNode.then(ClientCommandRegistrationEvent.literal((String)"reset").executes(FogClientCommands::reset));
            fogNode = (LiteralArgumentBuilder)fogNode.then(ClientCommandRegistrationEvent.literal((String)"toggle").executes(FogClientCommands::toggle));
            fogNode = (LiteralArgumentBuilder)fogNode.then(ClientCommandRegistrationEvent.literal((String)"debug").executes(FogClientCommands::outputDebug));
            dispatcher.register(fogNode);
        });
    }

    private static int outputDebug(CommandContext<ClientCommandRegistrationEvent.ClientCommandSourceStack> commandContext) {
        Minecraft client = Minecraft.m_91087_();
        float tickDelta = client.m_91296_();
        FogManager manager = FogManager.INSTANCE;
        Object hexColor = Integer.toHexString(new Color((int)(manager.fogColorRed.get(tickDelta) * 255.0f), (int)(manager.fogColorGreen.get(tickDelta) * 255.0f), (int)(manager.fogColorBlue.get(tickDelta) * 255.0f)).toInt());
        hexColor = "\u00a7c" + ((String)hexColor).substring(0, 2) + "\u00a7a" + ((String)hexColor).substring(2, 4) + "\u00a79" + ((String)hexColor).substring(4);
        @Nullable ClientLevel clientWorld = client.f_91073_;
        if (clientWorld == null) {
            ((ClientCommandRegistrationEvent.ClientCommandSourceStack)commandContext.getSource()).arch$sendFailure((Component)Component.m_237115_((String)"fog.command.debug.failure"));
            return 0;
        }
        @NotNull String debugInfoTable = String.format("\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r Current Fog Manager State:\n\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r Raininess: \u00a76%.2f\u00a7r\n\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r \"Undergroundness\": \u00a76%.2f\u00a7r\n\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r Fog Start: \u00a76%.2f\u00a7r\n\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r Fog End: \u00a76%.2f\u00a7r\n\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r Darkness: \u00a76%.2f\u00a7r\n\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r Fog Color: \u00a76#%s\u00a7r\n\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r Current Sky Light: \u00a76%.2f\u00a7r\n\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r Current Block Light: \u00a76%.2f\u00a7r\n\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r Current Light: \u00a76%.2f\u00a7r\n\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r Current Start Multiplier: \u00a76%.2f\u00a7r\n\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r Current End Multiplier: \u00a76%.2f\u00a7r", Float.valueOf(manager.raininess.get(tickDelta)), Float.valueOf(manager.undergroundness.get(tickDelta)), Float.valueOf(manager.fogStart.get(tickDelta)), Float.valueOf(manager.fogEnd.get(tickDelta)), Float.valueOf(manager.darkness.get(tickDelta)), hexColor, Float.valueOf(manager.currentSkyLight.get(tickDelta)), Float.valueOf(manager.currentBlockLight.get(tickDelta)), Float.valueOf(manager.currentLight.get(tickDelta)), Float.valueOf(manager.currentStartMultiplier.get(tickDelta)), Float.valueOf(manager.currentEndMultiplier.get(tickDelta)));
        ((ClientCommandRegistrationEvent.ClientCommandSourceStack)commandContext.getSource()).arch$sendSuccess(() -> Component.m_237113_((String)debugInfoTable), false);
        return 1;
    }

    private static int reset(@NotNull CommandContext<ClientCommandRegistrationEvent.ClientCommandSourceStack> commandContext) {
        FogConfig.load();
        FogManager.INSTANCE = new FogManager();
        ((ClientCommandRegistrationEvent.ClientCommandSourceStack)commandContext.getSource()).arch$sendSuccess(() -> Component.m_237113_((String)"\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r ").m_7220_((Component)Component.m_237115_((String)"fog.command.reset").m_130940_(ChatFormatting.GOLD)), false);
        return 1;
    }

    public static int toggle(@NotNull CommandContext<ClientCommandRegistrationEvent.ClientCommandSourceStack> commandContext) {
        FogConfig config = FogConfig.getInstance();
        config.disableMod = !config.disableMod;
        FogConfig.save();
        ((ClientCommandRegistrationEvent.ClientCommandSourceStack)commandContext.getSource()).arch$sendSuccess(() -> Component.m_237113_((String)"\u00a7b\u00a77[\u00a7rFog\u00a7b\u00a77]\u00a7r ").m_7220_((Component)Component.m_237115_((String)("fog.command.toggle." + (config.disableMod ? "disabled" : "enabled"))).m_130940_(ChatFormatting.GOLD)), false);
        return 1;
    }
}

