/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.fog.client.registry;

import dev.imb11.fog.api.CustomFogDefinition;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.NotNull;

public class FogRegistry {
    private static final Map<TagKey<Structure>, CustomFogDefinition> STRUCTURE_TAG_FOG_REGISTRY = new ConcurrentHashMap<TagKey<Structure>, CustomFogDefinition>();
    private static final Map<ResourceLocation, CustomFogDefinition> STRUCTURE_FOG_REGISTRY = new ConcurrentHashMap<ResourceLocation, CustomFogDefinition>();
    private static final Map<TagKey<Biome>, CustomFogDefinition> BIOME_TAG_FOG_REGISTRY = new ConcurrentHashMap<TagKey<Biome>, CustomFogDefinition>();
    private static final Map<ResourceLocation, CustomFogDefinition> BIOME_FOG_REGISTRY = new ConcurrentHashMap<ResourceLocation, CustomFogDefinition>();
    private static final Map<ResourceLocation, ResourceLocation> TAGGED_BIOME_TO_FOG_CACHE = new ConcurrentHashMap<ResourceLocation, ResourceLocation>();
    private static final Map<ResourceLocation, Set<ResourceLocation>> TAGGED_BIOME_SKIP_LIST = new ConcurrentHashMap<ResourceLocation, Set<ResourceLocation>>();

    @NotNull
    public static Map<TagKey<Structure>, CustomFogDefinition> getStructureTagFogRegistry() {
        return STRUCTURE_TAG_FOG_REGISTRY;
    }

    @NotNull
    public static Map<ResourceLocation, CustomFogDefinition> getStructureFogRegistry() {
        return STRUCTURE_FOG_REGISTRY;
    }

    @NotNull
    public static Map<TagKey<Biome>, CustomFogDefinition> getBiomeTagFogRegistry() {
        return BIOME_TAG_FOG_REGISTRY;
    }

    @NotNull
    public static Map<ResourceLocation, CustomFogDefinition> getBiomeFogRegistry() {
        return BIOME_FOG_REGISTRY;
    }

    @NotNull
    public static CustomFogDefinition getFogDefinitionOrDefault(@NotNull ResourceLocation biomeId, @NotNull Level world) {
        CustomFogDefinition biomeFogDefinition = FogRegistry.getBiomeFogRegistry().get(biomeId);
        if (biomeFogDefinition != null) {
            return biomeFogDefinition;
        }
        ResourceLocation cachedFogId = TAGGED_BIOME_TO_FOG_CACHE.get(biomeId);
        if (cachedFogId != null) {
            return FogRegistry.getBiomeTagFogRegistry().get(TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)cachedFogId));
        }
        Set skippedTags = TAGGED_BIOME_SKIP_LIST.getOrDefault(biomeId, new HashSet());
        Registry biomeRegistry = world.m_9598_().m_175515_(Registries.f_256952_);
        for (Map.Entry<TagKey<Biome>, CustomFogDefinition> biomeTagFogEntry : FogRegistry.getBiomeTagFogRegistry().entrySet()) {
            Optional entryListOptional;
            TagKey<Biome> tagKey = biomeTagFogEntry.getKey();
            ResourceLocation tagId = tagKey.f_203868_();
            if (skippedTags.contains(tagId) || !(entryListOptional = biomeRegistry.m_203431_(tagKey)).isPresent()) continue;
            HolderSet.Named entryList = (HolderSet.Named)entryListOptional.get();
            for (Holder entry : entryList) {
                if (!((ResourceKey)entry.m_203543_().get()).m_135782_().equals((Object)biomeId)) continue;
                TAGGED_BIOME_TO_FOG_CACHE.put(biomeId, tagId);
                TAGGED_BIOME_SKIP_LIST.put(biomeId, skippedTags);
                return biomeTagFogEntry.getValue();
            }
            skippedTags.add(tagId);
        }
        TAGGED_BIOME_SKIP_LIST.put(biomeId, skippedTags);
        return CustomFogDefinition.DEFAULT;
    }

    public static void resetCaches() {
        TAGGED_BIOME_TO_FOG_CACHE.clear();
        TAGGED_BIOME_SKIP_LIST.clear();
    }
}

