/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.fog.client.util.math;

import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public record DarknessCalculation(float fogStart, float fogEnd, float darknessValue) {
    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static DarknessCalculation of(@NotNull Minecraft client, float fogStart, float fogEnd, float deltaTick) {
        MobEffectInstance effect;
        float renderDistance = client.f_91063_.m_109152_() * 16.0f;
        Entity entity = client.f_91075_;
        float darknessValue = 0.0f;
        if (!(entity instanceof LivingEntity)) {
            return new DarknessCalculation(fogStart, fogEnd, darknessValue);
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (livingEntity.m_21023_(MobEffects.f_19610_)) {
            fogStart = 64.0f / renderDistance;
            fogEnd = 128.0f / renderDistance;
            darknessValue = 1.0f;
        } else if (livingEntity.m_21023_(MobEffects.f_216964_) && (effect = livingEntity.m_21124_(MobEffects.f_216964_)) != null && effect.m_216895_().isPresent()) {
            float factor = ((Double)client.f_91066_.m_231926_().m_231551_()).floatValue();
            float intensity = ((MobEffectInstance.FactorData)effect.m_216895_().get()).m_238413_(livingEntity, deltaTick) * factor;
            float darknessScale = DarknessCalculation.calculateDarknessScale(livingEntity, deltaTick);
            fogStart = 128.0f / renderDistance * (1.0f - darknessScale);
            fogEnd = 240.0f / renderDistance;
            darknessValue = intensity;
        }
        return new DarknessCalculation(fogStart, fogEnd, darknessValue);
    }

    private static float calculateDarknessScale(@NotNull LivingEntity entity, float deltaTick) {
        float darknessFactor = ((MobEffectInstance.FactorData)entity.m_21124_(MobEffects.f_216964_).m_216895_().get()).m_238413_(entity, deltaTick);
        float factor = 0.45f * darknessFactor;
        return Math.max(0.0f, Mth.m_14089_((float)(((float)entity.f_19797_ - deltaTick) * (float)Math.PI * 0.025f)) * factor);
    }
}

