/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block;

import cy.jdkdigital.productivebees.common.block.entity.AmberBlockEntity;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import cy.jdkdigital.productivebees.init.ModBlocks;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Amber
extends BaseEntityBlock {
    public Amber(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.NORTH));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : Amber.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntityTypes.AMBER.get()), AmberBlockEntity::serverTick);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> state) {
        state.m_61104_(new Property[]{HorizontalDirectionalBlock.f_54117_});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    @NotNull
    public RenderShape m_7514_(@Nonnull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new AmberBlockEntity(pos, state);
    }

    public void m_6402_(Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @javax.annotation.Nullable LivingEntity player, @Nonnull ItemStack stack) {
        BlockEntity tileEntity = level.m_7702_(pos);
        if (!level.m_5776_() && tileEntity instanceof AmberBlockEntity) {
            AmberBlockEntity amberBlockEntity = (AmberBlockEntity)tileEntity;
            CompoundTag tag = stack.m_41784_();
            amberBlockEntity.loadPacketNBT(tag);
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack stack = new ItemStack((ItemLike)ModBlocks.AMBER.get());
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof AmberBlockEntity) {
            try {
                CompoundTag tag = new CompoundTag();
                tag.m_128365_("BlockEntityTag", (Tag)blockEntity.m_187482_());
                stack.m_41751_(tag);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stack;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockState below = level.m_8055_(pos.m_7495_());
        if (below.m_204336_(BlockTags.f_13087_)) {
            for (int i = 0; i < random.m_188503_(1) + 1; ++i) {
                this.trySpawnDripParticles(level, pos, state);
            }
        }
    }

    private void trySpawnDripParticles(Level level, BlockPos pos, BlockState state) {
        VoxelShape voxelshape;
        double d0;
        if (state.m_60819_().m_76178_() && !(level.f_46441_.m_188501_() < 0.3f) && (d0 = (voxelshape = state.m_60812_((BlockGetter)level, pos)).m_83297_(Direction.Axis.Y)) >= 1.0 && !state.m_204336_(BlockTags.f_13049_)) {
            double d1 = voxelshape.m_83288_(Direction.Axis.Y);
            if (d1 > 0.0) {
                this.spawnParticle(level, pos, voxelshape, (double)pos.m_123342_() + d1 - 0.05);
            } else {
                BlockPos blockpos = pos.m_7495_();
                BlockState blockstate = level.m_8055_(blockpos);
                VoxelShape voxelshape1 = blockstate.m_60812_((BlockGetter)level, blockpos);
                double d2 = voxelshape1.m_83297_(Direction.Axis.Y);
                if ((d2 < 1.0 || !blockstate.m_60838_((BlockGetter)level, blockpos)) && blockstate.m_60819_().m_76178_()) {
                    this.spawnParticle(level, pos, voxelshape, (double)pos.m_123342_() - 0.05);
                }
            }
        }
    }

    private void spawnParticle(Level level, BlockPos pos, VoxelShape voxelShape, double y) {
        this.spawnFluidParticle(level, (double)pos.m_123341_() + voxelShape.m_83288_(Direction.Axis.X), (double)pos.m_123341_() + voxelShape.m_83297_(Direction.Axis.X), (double)pos.m_123343_() + voxelShape.m_83288_(Direction.Axis.Z), (double)pos.m_123343_() + voxelShape.m_83297_(Direction.Axis.Z), y);
    }

    private void spawnFluidParticle(Level level, double xMin, double xMax, double zMin, double zMax, double y) {
        level.m_7106_((ParticleOptions)ParticleTypes.f_123779_, Mth.m_14139_((double)level.f_46441_.m_188500_(), (double)xMin, (double)xMax), y, Mth.m_14139_((double)level.f_46441_.m_188500_(), (double)zMin, (double)zMax), 0.0, 0.0, 0.0);
    }
}

