/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import cy.jdkdigital.productivebees.common.block.Feeder;
import cy.jdkdigital.productivebees.common.block.entity.CapabilityBlockEntity;
import cy.jdkdigital.productivebees.container.FeederContainer;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.ForgeRegistries;

public class FeederBlockEntity
extends CapabilityBlockEntity {
    public Block baseBlock;
    private int tickCounter = 0;
    private LazyOptional<IItemHandlerModifiable> inventoryHandler;

    public FeederBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.FEEDER.get(), pos, state);
        this.refreshInventoryHandler();
    }

    public boolean isDouble() {
        return this.m_58900_().m_61143_((Property)BlockStateProperties.f_61397_) == SlabType.DOUBLE;
    }

    public Block getRandomBlockFromInventory(TagKey<Block> tag, RandomSource random) {
        ArrayList<Block> possibleBlocks = new ArrayList<Block>();
        for (ItemStack stack : this.getInventoryItems()) {
            Item item = stack.m_41720_();
            if (!(item instanceof BlockItem)) continue;
            BlockItem blockItem = (BlockItem)item;
            Block itemBlock = blockItem.m_40614_();
            if (tag != null && !itemBlock.m_204297_().m_203656_(tag)) continue;
            possibleBlocks.add(itemBlock);
        }
        return possibleBlocks.size() > 0 ? (Block)possibleBlocks.get(random.m_188503_(possibleBlocks.size())) : Blocks.f_50016_;
    }

    public ItemStack getSpecificItemFromInventory(Item item, RandomSource random) {
        ArrayList<ItemStack> possibleItems = new ArrayList<ItemStack>();
        for (ItemStack stack : this.getInventoryItems()) {
            if (!stack.m_150930_(item)) continue;
            possibleItems.add(stack);
        }
        return possibleItems.size() > 0 ? (ItemStack)possibleItems.get(random.m_188503_(possibleItems.size())) : ItemStack.f_41583_;
    }

    public List<ItemStack> getInventoryItems() {
        return this.inventoryHandler.map(h -> {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (int slot = 0; slot < h.getSlots(); ++slot) {
                items.add(h.getStackInSlot(slot));
            }
            return items;
        }).filter(itemStacks -> !itemStacks.isEmpty()).orElse(new ArrayList());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Nonnull
    public Component m_7755_() {
        if (this.isDouble()) {
            return Component.m_237115_((String)(((Block)ModBlocks.FEEDER.get()).m_7705_() + "_double"));
        }
        return Component.m_237115_((String)((Block)ModBlocks.FEEDER.get()).m_7705_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new FeederContainer(windowId, playerInventory, this);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        if (level instanceof ServerLevel && blockEntity instanceof FeederBlockEntity && ++((FeederBlockEntity)blockEntity).tickCounter % 164 == 0 && ((Boolean)state.m_61143_((Property)Feeder.HONEYLOGGED)).booleanValue()) {
            List entities = level.m_45976_(Bee.class, new AABB(pos));
            for (Bee entity : entities) {
                if (entity == null) continue;
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 80, 0, false, true));
            }
        }
    }

    @Override
    public void savePacketNBT(CompoundTag tag) {
        super.savePacketNBT(tag);
        if (this.baseBlock != null) {
            tag.m_128359_("baseBlock", ForgeRegistries.BLOCKS.getKey((Object)this.baseBlock).toString());
        }
    }

    @Override
    public void loadPacketNBT(CompoundTag tag) {
        super.loadPacketNBT(tag);
        if (tag.m_128441_("baseBlock")) {
            this.baseBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(tag.m_128461_("baseBlock")));
        }
    }

    public void refreshInventoryHandler() {
        this.inventoryHandler = LazyOptional.of(() -> new InventoryHandlerHelper.BlockEntityItemStackHandler(this.isDouble() ? 6 : 3, this){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack, boolean fromAutomation) {
                return true;
            }

            public boolean isInputSlot(int slot) {
                return true;
            }

            public boolean isInputSlotItem(int slot, ItemStack item) {
                return true;
            }

            public int[] getOutputSlots() {
                if (FeederBlockEntity.this.isDouble()) {
                    return new int[]{0, 1, 2, 3, 4, 5};
                }
                return new int[]{0, 1, 2};
            }

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                FeederBlockEntity.this.m_6596_();
            }
        });
    }
}

