/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.event;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.client.model.BeeNestHelmetModel;
import cy.jdkdigital.productivebees.client.render.entity.DyeBeeRenderer;
import cy.jdkdigital.productivebees.client.render.entity.HoarderBeeRenderer;
import cy.jdkdigital.productivebees.client.render.entity.ProductiveBeeRenderer;
import cy.jdkdigital.productivebees.client.render.entity.RancherBeeRenderer;
import cy.jdkdigital.productivebees.client.render.entity.model.HoarderBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.MediumBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.MediumCrystalBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.MediumElvisBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.MediumFoliageBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.MediumShellBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.ProductiveBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.RancherBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.SlimBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.SlimyBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.SmallBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.ThiccBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.TinyBeeModel;
import cy.jdkdigital.productivebees.common.block.CanvasBeehive;
import cy.jdkdigital.productivebees.common.block.CanvasExpansionBox;
import cy.jdkdigital.productivebees.common.block.CombBlock;
import cy.jdkdigital.productivebees.common.block.entity.CanvasBeehiveBlockEntity;
import cy.jdkdigital.productivebees.common.block.entity.CanvasExpansionBoxBlockEntity;
import cy.jdkdigital.productivebees.common.block.nest.WoodNest;
import cy.jdkdigital.productivebees.common.item.Gene;
import cy.jdkdigital.productivebees.common.item.Honeycomb;
import cy.jdkdigital.productivebees.common.item.SpawnEgg;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import cy.jdkdigital.productivebees.util.BeeAttributes;
import cy.jdkdigital.productivebees.util.BeeCreator;
import cy.jdkdigital.productivebees.util.ColorUtil;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="productivebees", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientSetupEvents {
    @SubscribeEvent
    public static void tabContents(BuildCreativeModeTabContentsEvent event) {
        String beeType;
        if (event.getTabKey().equals(ProductiveBees.TAB_KEY)) {
            for (RegistryObject registryObject : ModItems.ITEMS.getEntries()) {
                if (registryObject.equals(ModItems.CONFIGURABLE_HONEYCOMB) || registryObject.equals(ModItems.CONFIGURABLE_COMB_BLOCK) || registryObject.equals(ModItems.CONFIGURABLE_SPAWN_EGG) || registryObject.equals(ModItems.GENE) || registryObject.equals(ModItems.GENE_BOTTLE) || registryObject.equals(ModItems.ADV_BREED_ALL_BEES) || registryObject.equals(ModItems.ADV_BREED_BEE)) continue;
                event.m_246342_(new ItemStack((ItemLike)registryObject.get(), 1));
            }
            for (Map.Entry entry : BeeReloadListener.INSTANCE.getData().entrySet()) {
                beeType = (String)entry.getKey();
                if (!((CompoundTag)entry.getValue()).m_128471_("createComb")) continue;
                ItemStack comb = new ItemStack((ItemLike)ModItems.CONFIGURABLE_HONEYCOMB.get());
                BeeCreator.setTag(beeType, comb);
                event.m_246342_(comb);
                ItemStack combBlock = new ItemStack((ItemLike)ModItems.CONFIGURABLE_COMB_BLOCK.get());
                BeeCreator.setTag(beeType, combBlock);
                event.m_246342_(combBlock);
            }
            event.m_246342_(Gene.getStack(BeeAttributes.PRODUCTIVITY, 0, 1, 100));
            event.m_246342_(Gene.getStack(BeeAttributes.PRODUCTIVITY, 1, 1, 100));
            event.m_246342_(Gene.getStack(BeeAttributes.PRODUCTIVITY, 2, 1, 100));
            event.m_246342_(Gene.getStack(BeeAttributes.PRODUCTIVITY, 3, 1, 100));
            event.m_246342_(Gene.getStack(BeeAttributes.WEATHER_TOLERANCE, 0, 1, 100));
            event.m_246342_(Gene.getStack(BeeAttributes.WEATHER_TOLERANCE, 1, 1, 100));
            event.m_246342_(Gene.getStack(BeeAttributes.WEATHER_TOLERANCE, 2, 1, 100));
            event.m_246342_(Gene.getStack(BeeAttributes.BEHAVIOR, 0, 1, 100));
            event.m_246342_(Gene.getStack(BeeAttributes.BEHAVIOR, 1, 1, 100));
            event.m_246342_(Gene.getStack(BeeAttributes.BEHAVIOR, 2, 1, 100));
            event.m_246342_(Gene.getStack(BeeAttributes.TEMPER, 0, 1, 100));
            event.m_246342_(Gene.getStack(BeeAttributes.TEMPER, 1, 1, 100));
            event.m_246342_(Gene.getStack(BeeAttributes.TEMPER, 2, 1, 100));
            event.m_246342_(Gene.getStack(BeeAttributes.TEMPER, 3, 1, 100));
            event.m_246342_(Gene.getStack(BeeAttributes.ENDURANCE, 0, 1, 100));
            event.m_246342_(Gene.getStack(BeeAttributes.ENDURANCE, 1, 1, 100));
            event.m_246342_(Gene.getStack(BeeAttributes.ENDURANCE, 2, 1, 100));
            event.m_246342_(Gene.getStack(BeeAttributes.ENDURANCE, 3, 1, 100));
        }
        if (event.getTabKey().equals(ProductiveBees.TAB_KEY) || event.getTabKey().equals((Object)CreativeModeTabs.f_256731_)) {
            for (RegistryObject registryObject : ModItems.SPAWN_EGGS) {
                if (registryObject.equals(ModItems.CONFIGURABLE_SPAWN_EGG)) continue;
                event.accept((Supplier)registryObject);
            }
            for (Map.Entry entry : BeeReloadListener.INSTANCE.getData().entrySet()) {
                beeType = (String)entry.getKey();
                event.m_246342_(BeeCreator.getSpawnEgg(beeType));
            }
        }
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        Item item;
        for (RegistryObject<Item> eggItem : ModItems.SPAWN_EGGS) {
            item = (Item)eggItem.get();
            if (!(item instanceof SpawnEgg)) continue;
            event.register((stack, tintIndex) -> ((SpawnEgg)item).getColor(tintIndex, stack), new ItemLike[]{item});
        }
        for (RegistryObject registryItem : ModItems.ITEMS.getEntries()) {
            item = (Item)registryItem.get();
            if (item instanceof Honeycomb) {
                event.register(((Honeycomb)item)::getColor, new ItemLike[]{item});
                continue;
            }
            if (!(item instanceof BlockItem)) continue;
            Block block = ((BlockItem)item).m_40614_();
            if (block instanceof CombBlock) {
                event.register((stack, tintIndex) -> ((CombBlock)block).getColor(stack), new ItemLike[]{item});
            }
            if (!(block instanceof WoodNest)) continue;
            event.register((stack, tintIndex) -> ((WoodNest)block).getColor(tintIndex), new ItemLike[]{block});
        }
        event.register((stack, tintIndex) -> {
            BlockState blockstate = ((BlockItem)stack.m_41720_()).m_40614_().m_49966_();
            return event.getBlockColors().m_92577_(blockstate, null, null, tintIndex);
        }, new ItemLike[]{(ItemLike)ModBlocks.BUMBLE_BEE_NEST.get()});
        ModBlocks.HIVELIST.forEach((modid, strings) -> {
            if (FMLLoader.getLaunchHandler().isData() || ModList.get().isLoaded(modid)) {
                strings.forEach((name, type) -> {
                    if (!type.hasTexture()) {
                        name = modid.equals("productivebees") ? name : modid + "_" + name;
                        TextColor primary = TextColor.m_131268_((String)type.primary());
                        event.register((stack, tintIndex) -> tintIndex == 0 ? primary.m_131265_() : -1, new ItemLike[]{(ItemLike)ModBlocks.HIVES.get("advanced_" + name + "_beehive").get(), (ItemLike)ModBlocks.EXPANSIONS.get("expansion_box_" + name).get()});
                    }
                });
            }
        });
        ModBlocks.hiveStyles.forEach(style -> event.register((stack, tintIndex) -> {
            BlockItem blockItem;
            Item patt8859$temp;
            if (tintIndex == 0 && (patt8859$temp = stack.m_41720_()) instanceof BlockItem && ((blockItem = (BlockItem)patt8859$temp).m_40614_() instanceof CanvasBeehive || blockItem.m_40614_() instanceof CanvasExpansionBox) && stack.m_41783_() != null && stack.m_41783_().m_128441_("color")) {
                return stack.m_41783_().m_128451_("color");
            }
            return 0xFFFFFF;
        }, new ItemLike[]{(ItemLike)ModBlocks.HIVES.get("advanced_" + style + "_canvas_beehive").get(), (ItemLike)ModBlocks.EXPANSIONS.get("expansion_box_" + style + "_canvas").get()}));
    }

    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((blockState, lightReader, pos, tintIndex) -> lightReader != null && pos != null ? BiomeColors.m_108793_((BlockAndTintGetter)lightReader, (BlockPos)pos) : -1, new Block[]{(Block)ModBlocks.SUGAR_CANE_NEST.get()});
        event.register((blockState, lightReader, pos, tintIndex) -> lightReader != null && pos != null ? BiomeColors.m_108793_((BlockAndTintGetter)lightReader, (BlockPos)pos) : GrassColor.m_46415_((double)0.5, (double)1.0), new Block[]{(Block)ModBlocks.BUMBLE_BEE_NEST.get()});
        for (RegistryObject registryBlock : ModBlocks.BLOCKS.getEntries()) {
            Block block = (Block)registryBlock.get();
            if (block instanceof CombBlock) {
                event.register((blockState, lightReader, pos, tintIndex) -> tintIndex == 0 ? ((CombBlock)block).getColor(lightReader, pos) : -1, new Block[]{block});
            }
            if (!(block instanceof WoodNest)) continue;
            event.register((blockState, lightReader, pos, tintIndex) -> ((WoodNest)block).getColor(tintIndex), new Block[]{block});
        }
        ModBlocks.HIVELIST.forEach((modid, strings) -> {
            if (FMLLoader.getLaunchHandler().isData() || ModList.get().isLoaded(modid)) {
                strings.forEach((name, type) -> {
                    if (!type.hasTexture()) {
                        name = modid.equals("productivebees") ? name : modid + "_" + name;
                        event.register((blockState, lightReader, pos, tintIndex) -> tintIndex == 0 && type.primary() != null ? ColorUtil.getCacheColor(type.primary()) : -1, new Block[]{(Block)ModBlocks.HIVES.get("advanced_" + name + "_beehive").get(), (Block)ModBlocks.EXPANSIONS.get("expansion_box_" + name).get()});
                    }
                });
            }
        });
        ModBlocks.hiveStyles.forEach(style -> event.register((blockState, lightReader, pos, tintIndex) -> {
            if (tintIndex == 0 && pos != null && (blockState.m_60734_() instanceof CanvasBeehive || blockState.m_60734_() instanceof CanvasExpansionBox) && lightReader != null) {
                BlockEntity patt11569$temp = lightReader.m_7702_(pos);
                if (patt11569$temp instanceof CanvasBeehiveBlockEntity) {
                    CanvasBeehiveBlockEntity canvasBlockEntity = (CanvasBeehiveBlockEntity)patt11569$temp;
                    return canvasBlockEntity.getColor(tintIndex);
                }
                BlockEntity patt11765$temp = lightReader.m_7702_(pos);
                if (patt11765$temp instanceof CanvasExpansionBoxBlockEntity) {
                    CanvasExpansionBoxBlockEntity canvasBlockEntity = (CanvasExpansionBoxBlockEntity)patt11765$temp;
                    return canvasBlockEntity.getColor(tintIndex);
                }
            }
            return -1;
        }, new Block[]{(Block)ModBlocks.HIVES.get("advanced_" + style + "_canvas_beehive").get(), (Block)ModBlocks.EXPANSIONS.get("expansion_box_" + style + "_canvas").get()}));
    }

    @SubscribeEvent
    public static void layerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_MAIN_LAYER, ProductiveBeeModel::createBodyLayer);
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_HOARDER_LAYER, HoarderBeeModel::createLayer);
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_RANCHER_LAYER, RancherBeeModel::createLayer);
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_THICC_LAYER, ThiccBeeModel::createLayer);
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_DEFAULT_LAYER, MediumBeeModel::createLayer);
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_DEFAULT_CRYSTAL_LAYER, MediumCrystalBeeModel::createLayer);
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_DEFAULT_SHELL_LAYER, MediumShellBeeModel::createLayer);
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_DEFAULT_FOLIAGE_LAYER, MediumFoliageBeeModel::createLayer);
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_ELVIS_LAYER, MediumElvisBeeModel::createLayer);
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_SLIM_LAYER, SlimBeeModel::createLayer);
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_SLIMY_LAYER, SlimyBeeModel::createLayer);
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_SMALL_LAYER, SmallBeeModel::createLayer);
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_SMALL_LAYER, SmallBeeModel::createLayer);
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_TINY_LAYER, TinyBeeModel::createLayer);
        event.registerLayerDefinition(BeeNestHelmetModel.LAYER_LOCATION, BeeNestHelmetModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerEntityRendering(EntityRenderersEvent.RegisterRenderers event) {
        for (RegistryObject registryObject : ModEntities.HIVE_BEES.getEntries()) {
            EntityType bee = (EntityType)registryObject.get();
            String key = bee.m_20675_();
            if (key.contains("dye_bee")) {
                event.registerEntityRenderer(bee, DyeBeeRenderer::new);
                continue;
            }
            if (key.contains("rancher_bee") || key.contains("farmer_bee")) {
                event.registerEntityRenderer(bee, RancherBeeRenderer::new);
                continue;
            }
            if (key.contains("hoarder_bee")) {
                event.registerEntityRenderer(bee, HoarderBeeRenderer::new);
                continue;
            }
            event.registerEntityRenderer(bee, ProductiveBeeRenderer::new);
        }
        for (RegistryObject registryObject : ModEntities.SOLITARY_BEES.getEntries()) {
            event.registerEntityRenderer((EntityType)registryObject.get(), ProductiveBeeRenderer::new);
        }
        event.registerEntityRenderer((EntityType)ModEntities.BEE_BOMB.get(), ThrownItemRenderer::new);
    }
}

