/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.ForgeRenderTypes;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.CompositeModel;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;
import net.minecraftforge.client.model.pipeline.QuadBakingVertexConsumer;
import net.minecraftforge.client.model.pipeline.TransformingVertexPipeline;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.common.ColorLoadable;
import slimeknights.mantle.data.loadable.primitive.BooleanLoadable;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.util.ItemLayerPixels;
import slimeknights.mantle.util.LogicHelper;
import slimeknights.mantle.util.ReversedListBuilder;

public class MantleItemLayerModel
implements IUnbakedGeometry<MantleItemLayerModel> {
    public static final IGeometryLoader<MantleItemLayerModel> LOADER = MantleItemLayerModel::deserialize;
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.UP, Direction.DOWN};
    private static final Direction[] VERTICALS = new Direction[]{Direction.WEST, Direction.EAST};
    private final List<LayerData> layers;
    private List<Material> textures = Collections.emptyList();

    private LayerData getLayer(int index) {
        return LogicHelper.getOrDefault(this.layers, index, LayerData.DEFAULT);
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext owner) {
        ArrayList<Material> builder = new ArrayList<Material>();
        int i = 0;
        while (owner.hasMaterial("layer" + i)) {
            builder.add(owner.getMaterial("layer" + i));
            ++i;
        }
        this.textures = List.copyOf(builder);
    }

    public static RenderTypeGroup getDefaultRenderType(IGeometryBakingContext context) {
        ResourceLocation renderTypeHint = context.getRenderTypeHint();
        if (renderTypeHint != null) {
            return context.getRenderType(renderTypeHint);
        }
        return new RenderTypeGroup(RenderType.m_110466_(), ForgeRenderTypes.ITEM_UNSORTED_TRANSLUCENT.get());
    }

    public static ModelState applyTransform(ModelState modelState, Transformation transformation) {
        if (transformation.isIdentity()) {
            return modelState;
        }
        return UnbakedGeometryHelper.composeRootTransformIntoModelState((ModelState)modelState, (Transformation)transformation);
    }

    public BakedModel bake(IGeometryBakingContext owner, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        if (this.textures.isEmpty()) {
            throw new IllegalStateException("Empty textures list");
        }
        TextureAtlasSprite particle = spriteGetter.apply(owner.hasMaterial("particle") ? owner.getMaterial("particle") : this.textures.get(0));
        record QuadGroup(RenderTypeGroup renderType, Collection<BakedQuad> quads) {
        }
        ReversedListBuilder<QuadGroup> quadBuilder = new ReversedListBuilder<QuadGroup>();
        ItemLayerPixels pixels = this.textures.size() == 1 ? null : new ItemLayerPixels();
        modelTransform = MantleItemLayerModel.applyTransform(modelTransform, owner.getRootTransform());
        RenderTypeGroup normalRenderTypes = MantleItemLayerModel.getDefaultRenderType(owner);
        Transformation transform = modelTransform.m_6189_();
        for (int i = this.textures.size() - 1; i >= 0; --i) {
            TextureAtlasSprite sprite = spriteGetter.apply(this.textures.get(i));
            LayerData data = this.getLayer(i);
            quadBuilder.add(new QuadGroup(data.getRenderType(owner, normalRenderTypes), MantleItemLayerModel.getQuadsForSprite(data.color(), data.noTint() ? -1 : i, sprite, transform, data.luminosity(), pixels)));
        }
        CompositeModel.Baked.Builder modelBuilder = CompositeModel.Baked.builder((IGeometryBakingContext)owner, (TextureAtlasSprite)particle, (ItemOverrides)overrides, (ItemTransforms)owner.getTransforms());
        quadBuilder.build(quadGroup -> modelBuilder.addQuads(quadGroup.renderType, quadGroup.quads));
        return modelBuilder.build();
    }

    public static List<BakedQuad> getQuadsForSprite(int color, int tint, TextureAtlasSprite sprite, Transformation transform, int luminosity) {
        return MantleItemLayerModel.getQuadsForSprite(color, tint, sprite, transform, luminosity, null);
    }

    /*
     * WARNING - void declaration
     */
    public static List<BakedQuad> getQuadsForSprite(int color, int tint, TextureAtlasSprite sprite, Transformation transform, int emissivity, @Nullable ItemLayerPixels pixels) {
        int off;
        boolean face;
        boolean canDraw;
        boolean building;
        int u;
        int u2;
        ArrayList builder = new ArrayList();
        SpriteContents contents = sprite.m_245424_();
        int uMax = contents.m_246492_();
        int vMax = contents.m_245330_();
        FaceData faceData = new FaceData(uMax, vMax);
        boolean translucent = false;
        PrimitiveIterator.OfInt iterator = sprite.m_245424_().m_245638_().iterator();
        boolean hasFrames = iterator.hasNext();
        while (iterator.hasNext()) {
            int f = iterator.nextInt();
            boolean[] blArray = new boolean[uMax];
            Arrays.fill(blArray, true);
            for (int v = 0; v < vMax; ++v) {
                boolean ptu = true;
                for (u2 = 0; u2 < uMax; ++u2) {
                    boolean t;
                    int alpha = sprite.getPixelRGBA(f, u2, vMax - v - 1) >> 24 & 0xFF;
                    boolean bl = t = (float)alpha / 255.0f <= 0.1f;
                    if (!t && alpha < 255) {
                        translucent = true;
                    }
                    if (ptu && !t) {
                        faceData.set(Direction.WEST, u2, v);
                    }
                    if (!ptu && t) {
                        faceData.set(Direction.EAST, u2 - 1, v);
                    }
                    if (blArray[u2] && !t) {
                        faceData.set(Direction.UP, u2, v);
                    }
                    if (!blArray[u2] && t) {
                        faceData.set(Direction.DOWN, u2, v - 1);
                    }
                    ptu = t;
                    blArray[u2] = t;
                }
                if (ptu) continue;
                faceData.set(Direction.EAST, uMax - 1, v);
            }
            for (u = 0; u < uMax; ++u) {
                if (blArray[u]) continue;
                faceData.set(Direction.DOWN, u, vMax - 1);
            }
        }
        QuadBakingVertexConsumer quadBuilder = new QuadBakingVertexConsumer(builder::add);
        quadBuilder.setSprite(sprite);
        quadBuilder.setTintIndex(tint);
        quadBuilder.setShade(false);
        quadBuilder.setHasAmbientOcclusion(true);
        QuadBakingVertexConsumer quadConsumer = quadBuilder;
        if (!transform.isIdentity()) {
            quadConsumer = new TransformingVertexPipeline((VertexConsumer)quadBuilder, transform);
        }
        for (Direction facing : HORIZONTALS) {
            for (int v = 0; v < vMax; ++v) {
                int uStart = 0;
                int uEnd = uMax;
                building = false;
                for (int u3 = 0; u3 < uMax; ++u3) {
                    canDraw = pixels == null || !pixels.get(u3, v, uMax, vMax);
                    boolean bl = face = canDraw && faceData.get(facing, u3, v);
                    if (face) {
                        uEnd = u3 + 1;
                        if (building) continue;
                        building = true;
                        uStart = u3;
                        continue;
                    }
                    if (!building || canDraw && !translucent) continue;
                    int off2 = facing == Direction.DOWN ? 1 : 0;
                    MantleItemLayerModel.buildSideQuad(quadBuilder, (VertexConsumer)quadConsumer, facing, color, sprite, uStart, v + off2, uEnd - uStart, emissivity);
                    building = false;
                }
                if (!building) continue;
                off = facing == Direction.DOWN ? 1 : 0;
                MantleItemLayerModel.buildSideQuad(quadBuilder, (VertexConsumer)quadConsumer, facing, color, sprite, uStart, v + off, uEnd - uStart, emissivity);
            }
        }
        Direction[] directionArray = VERTICALS;
        u = directionArray.length;
        for (u2 = 0; u2 < u; ++u2) {
            Direction facing = directionArray[u2];
            for (int u4 = 0; u4 < uMax; ++u4) {
                int vStart = 0;
                int vEnd = vMax;
                building = false;
                for (int v = 0; v < vMax; ++v) {
                    canDraw = pixels == null || !pixels.get(u4, v, uMax, vMax);
                    boolean bl = face = canDraw && faceData.get(facing, u4, v);
                    if (face) {
                        vEnd = v + 1;
                        if (building) continue;
                        building = true;
                        vStart = v;
                        continue;
                    }
                    if (!building || canDraw && !translucent) continue;
                    int off2 = facing == Direction.EAST ? 1 : 0;
                    MantleItemLayerModel.buildSideQuad(quadBuilder, (VertexConsumer)quadConsumer, facing, color, sprite, u4 + off2, vStart, vEnd - vStart, emissivity);
                    building = false;
                }
                if (!building) continue;
                off = facing == Direction.EAST ? 1 : 0;
                MantleItemLayerModel.buildSideQuad(quadBuilder, (VertexConsumer)quadConsumer, facing, color, sprite, u4 + off, vStart, vEnd - vStart, emissivity);
            }
        }
        MantleItemLayerModel.buildQuad(quadBuilder, (VertexConsumer)quadConsumer, Direction.NORTH, color, emissivity, 0.0f, 0.0f, 0.46875f, sprite.m_118409_(), sprite.m_118412_(), 0.0f, 1.0f, 0.46875f, sprite.m_118409_(), sprite.m_118411_(), 1.0f, 1.0f, 0.46875f, sprite.m_118410_(), sprite.m_118411_(), 1.0f, 0.0f, 0.46875f, sprite.m_118410_(), sprite.m_118412_());
        MantleItemLayerModel.buildQuad(quadBuilder, (VertexConsumer)quadConsumer, Direction.SOUTH, color, emissivity, 0.0f, 0.0f, 0.53125f, sprite.m_118409_(), sprite.m_118412_(), 1.0f, 0.0f, 0.53125f, sprite.m_118410_(), sprite.m_118412_(), 1.0f, 1.0f, 0.53125f, sprite.m_118410_(), sprite.m_118411_(), 0.0f, 1.0f, 0.53125f, sprite.m_118409_(), sprite.m_118411_());
        if (pixels != null && hasFrames) {
            void var16_22;
            boolean bl = false;
            while (var16_22 < vMax) {
                for (u = 0; u < uMax; ++u) {
                    int alpha = sprite.getPixelRGBA(0, u, vMax - var16_22 - 1) >> 24 & 0xFF;
                    if (!((float)alpha / 255.0f > 0.1f)) continue;
                    pixels.set(u, (int)var16_22, uMax, vMax);
                }
                ++var16_22;
            }
        }
        return List.copyOf(builder);
    }

    public static BakedQuad getQuadForGui(int color, int tint, TextureAtlasSprite sprite, Transformation transform, int emissivity) {
        QuadBakingVertexConsumer.Buffered quadBuilder = new QuadBakingVertexConsumer.Buffered();
        quadBuilder.setSprite(sprite);
        quadBuilder.setTintIndex(tint);
        quadBuilder.setShade(false);
        quadBuilder.setHasAmbientOcclusion(true);
        QuadBakingVertexConsumer.Buffered quadConsumer = quadBuilder;
        if (!transform.isIdentity()) {
            quadConsumer = new TransformingVertexPipeline((VertexConsumer)quadBuilder, transform);
        }
        MantleItemLayerModel.buildQuad((QuadBakingVertexConsumer)quadBuilder, (VertexConsumer)quadConsumer, Direction.SOUTH, color, emissivity, 0.0f, 0.0f, 0.53125f, sprite.m_118409_(), sprite.m_118412_(), 1.0f, 0.0f, 0.53125f, sprite.m_118410_(), sprite.m_118412_(), 1.0f, 1.0f, 0.53125f, sprite.m_118410_(), sprite.m_118411_(), 0.0f, 1.0f, 0.53125f, sprite.m_118409_(), sprite.m_118411_());
        return quadBuilder.getQuad();
    }

    private static void buildSideQuad(QuadBakingVertexConsumer builder, VertexConsumer consumer, Direction side, int color, TextureAtlasSprite sprite, int u, int v, int size, int luminosity) {
        float eps = 0.01f;
        SpriteContents contents = sprite.m_245424_();
        int width = contents.m_246492_();
        int height = contents.m_245330_();
        float x0 = (float)u / (float)width;
        float y0 = (float)v / (float)height;
        float x1 = x0;
        float y1 = y0;
        float z0 = 0.46875f;
        float z1 = 0.53125f;
        switch (side) {
            case WEST: {
                z0 = 0.53125f;
                z1 = 0.46875f;
            }
            case EAST: {
                y1 = (float)(v + size) / (float)height;
                break;
            }
            case DOWN: {
                z0 = 0.53125f;
                z1 = 0.46875f;
            }
            case UP: {
                x1 = (float)(u + size) / (float)width;
                break;
            }
            default: {
                throw new IllegalArgumentException("can't handle z-oriented side");
            }
        }
        float dx = (float)side.m_122436_().m_123341_() * 0.01f / (float)width;
        float dy = (float)side.m_122436_().m_123342_() * 0.01f / (float)height;
        float u0 = 16.0f * (x0 - dx);
        float u1 = 16.0f * (x1 - dx);
        float v0 = 16.0f * (1.0f - y0 - dy);
        float v1 = 16.0f * (1.0f - y1 - dy);
        MantleItemLayerModel.buildQuad(builder, consumer, side.m_122434_() == Direction.Axis.Y ? side.m_122424_() : side, color, luminosity, x0, y0, z0, sprite.m_118367_((double)u0), sprite.m_118393_((double)v0), x1, y1, z0, sprite.m_118367_((double)u1), sprite.m_118393_((double)v1), x1, y1, z1, sprite.m_118367_((double)u1), sprite.m_118393_((double)v1), x0, y0, z1, sprite.m_118367_((double)u0), sprite.m_118393_((double)v0));
    }

    protected static void buildQuad(QuadBakingVertexConsumer builder, VertexConsumer consumer, Direction side, int color, int luminosity, float x0, float y0, float z0, float u0, float v0, float x1, float y1, float z1, float u1, float v1, float x2, float y2, float z2, float u2, float v2, float x3, float y3, float z3, float u3, float v3) {
        builder.setDirection(side);
        MantleItemLayerModel.putVertex(consumer, side, x0, y0, z0, u0, v0, color, luminosity);
        MantleItemLayerModel.putVertex(consumer, side, x1, y1, z1, u1, v1, color, luminosity);
        MantleItemLayerModel.putVertex(consumer, side, x2, y2, z2, u2, v2, color, luminosity);
        MantleItemLayerModel.putVertex(consumer, side, x3, y3, z3, u3, v3, color, luminosity);
    }

    private static void putVertex(VertexConsumer consumer, Direction side, float x, float y, float z, float u, float v, int color, int luminosity) {
        consumer.m_5483_((double)x, (double)y, (double)z);
        consumer.m_193479_(color);
        consumer.m_5601_((float)side.m_122429_(), (float)side.m_122430_(), (float)side.m_122431_());
        consumer.m_7421_(u, v);
        int light = luminosity << 4;
        consumer.m_7120_(light, light);
        consumer.m_5752_();
    }

    public static MantleItemLayerModel deserialize(JsonObject json, JsonDeserializationContext context) {
        return new MantleItemLayerModel(LayerData.LIST_LOADABLE.getIfPresent(json, "layers"));
    }

    public MantleItemLayerModel(List<LayerData> layers) {
        this.layers = layers;
    }

    public record LayerData(int color, int luminosity, boolean noTint, @Nullable ResourceLocation renderType) {
        private static final LayerData DEFAULT = new LayerData(-1, 0, false, null);
        public static final RecordLoadable<LayerData> LOADABLE = RecordLoadable.create(ColorLoadable.ALPHA.defaultField("color", false, LayerData::color), IntLoadable.range(0, 15).defaultField("luminosity", 0, LayerData::luminosity), BooleanLoadable.INSTANCE.defaultField("no_tint", false, false, LayerData::noTint), Loadables.RESOURCE_LOCATION.nullableField("render_type", LayerData::renderType), LayerData::new);
        public static final Loadable<List<LayerData>> LIST_LOADABLE = LOADABLE.list(1);

        public RenderTypeGroup getRenderType(IGeometryBakingContext context, RenderTypeGroup defaultType) {
            if (this.renderType == null) {
                return defaultType;
            }
            return context.getRenderType(this.renderType);
        }

        @Deprecated(forRemoval=true)
        public static LayerData fromJson(JsonObject json) {
            return LOADABLE.deserialize(json);
        }

        @Deprecated(forRemoval=true)
        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            LOADABLE.serialize(this, json);
            return json;
        }
    }

    private static class FaceData {
        private final EnumMap<Direction, BitSet> data = new EnumMap(Direction.class);
        private final int vMax;

        FaceData(int uMax, int vMax) {
            this.vMax = vMax;
            this.data.put(Direction.WEST, new BitSet(uMax * vMax));
            this.data.put(Direction.EAST, new BitSet(uMax * vMax));
            this.data.put(Direction.UP, new BitSet(uMax * vMax));
            this.data.put(Direction.DOWN, new BitSet(uMax * vMax));
        }

        public void set(Direction facing, int u, int v) {
            this.data.get(facing).set(this.getIndex(u, v));
        }

        public boolean get(Direction facing, int u, int v) {
            return this.data.get(facing).get(this.getIndex(u, v));
        }

        private int getIndex(int u, int v) {
            return v * this.vMax + u;
        }
    }
}

