/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.screen;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.client.screen.ElementScreen;

public class ScalableElementScreen
extends ElementScreen {
    public ScalableElementScreen(ResourceLocation texture, int x, int y, int w, int h, int texW, int texH) {
        super(texture, x, y, w, h, texW, texH);
    }

    public int drawScaledX(GuiGraphics graphics, int xPos, int yPos, int width) {
        for (int i = 0; i < width / this.w; ++i) {
            this.draw(graphics, xPos + i * this.w, yPos);
        }
        int remainder = width % this.w;
        if (remainder > 0) {
            graphics.m_280163_(this.texture, xPos + width - remainder, yPos, (float)this.x, (float)this.y, remainder, this.h, this.texW, this.texH);
        }
        return width;
    }

    public int drawScaledY(GuiGraphics graphics, int xPos, int yPos, int height) {
        for (int i = 0; i < height / this.h; ++i) {
            this.draw(graphics, xPos, yPos + i * this.h);
        }
        int remainder = height % this.h;
        if (remainder > 0) {
            graphics.m_280163_(this.texture, xPos, yPos + height - remainder, (float)this.x, (float)this.y, this.w, remainder, this.texW, this.texH);
        }
        return this.w;
    }

    public int drawScaledYUp(GuiGraphics graphics, int xPos, int yPos, int height) {
        int remainder = height % this.h;
        int offset = this.h - remainder;
        if (remainder > 0) {
            graphics.m_280163_(this.texture, xPos, yPos + offset, (float)this.x, (float)(this.y + offset), this.w, remainder, this.texW, this.texH);
        }
        return this.w;
    }

    public int drawScaled(GuiGraphics graphics, int xPos, int yPos, int width, int height) {
        int full = height / this.h;
        for (int i = 0; i < full; ++i) {
            this.drawScaledX(graphics, xPos, yPos + i * this.h, width);
        }
        yPos += full * this.h;
        int yRest = height % this.h;
        for (int i = 0; i < width / this.w; ++i) {
            this.drawScaledY(graphics, xPos + i * this.w, yPos, yRest);
        }
        int remainder = width % this.w;
        if (remainder > 0) {
            graphics.m_280163_(this.texture, xPos + width - remainder, yPos, (float)this.x, (float)this.y, remainder, yRest, this.texW, this.texH);
        }
        return width;
    }

    @Override
    public ScalableElementScreen move(int x, int y, int width, int height) {
        return new ScalableElementScreen(this.texture, x, y, width, height, this.texW, this.texH);
    }

    @Override
    public ScalableElementScreen shift(int xd, int yd) {
        return this.move(this.x + xd, this.y + yd, this.w, this.h);
    }
}

