/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.loot;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.primitive.StringLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;

public record LootTableInjection(ResourceLocation name, List<LootPoolInjection> pools) {
    public static final RecordLoadable<LootTableInjection> LOADABLE = RecordLoadable.create(Loadables.RESOURCE_LOCATION.requiredField("name", LootTableInjection::name), LootPoolInjection.LOADABLE.list(1).requiredField("pools", LootTableInjection::pools), LootTableInjection::new);

    public record LootPoolInjection(String name, LootPoolEntryContainer[] entries) {
        public static final RecordLoadable<LootPoolInjection> LOADABLE = RecordLoadable.create(StringLoadable.DEFAULT.requiredField("name", LootPoolInjection::name), Loadables.LOOT_ENTRY.list(1).requiredField("entries", pool -> List.of(pool.entries)), LootPoolInjection::new);

        public LootPoolInjection(String name, List<LootPoolEntryContainer> entries) {
            this(name, entries.toArray(new LootPoolEntryContainer[0]));
        }

        public void inject(LootTable table) {
            LootPool pool = table.getPool(this.name);
            if (pool != null) {
                int oldLength = pool.f_79023_.length;
                pool.f_79023_ = Arrays.copyOf(pool.f_79023_, oldLength + this.entries.length);
                System.arraycopy(this.entries, 0, pool.f_79023_, oldLength, this.entries.length);
            } else {
                Mantle.logger.warn("Failed to inject loot into {} pool {}", (Object)table.getLootTableId(), (Object)this.name);
            }
        }
    }

    public static class Builder {
        private final Map<String, List<LootPoolEntryContainer>> pools = new LinkedHashMap<String, List<LootPoolEntryContainer>>();

        @CanIgnoreReturnValue
        public Builder addToPool(String name, LootPoolEntryContainer ... entries) {
            Collections.addAll(this.pools.computeIfAbsent(name, n -> new ArrayList()), entries);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addToPool(LootPoolInjection injection) {
            return this.addToPool(injection.name, injection.entries);
        }

        public LootTableInjection build(ResourceLocation name) {
            return new LootTableInjection(name, this.pools.entrySet().stream().map(entry -> new LootPoolInjection((String)entry.getKey(), List.copyOf((Collection)entry.getValue()))).toList());
        }
    }
}

