/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.util.typed;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import slimeknights.mantle.util.typed.BackedTypedMap;
import slimeknights.mantle.util.typed.TypedMap;

public class TypedMapBuilder {
    private final Map<TypedMap.Key<?>, Object> builder = new HashMap();

    public TypedMapBuilder putAll(TypedMap map) {
        for (TypedMap.Key<?> key : map.keySet()) {
            this.builder.put(key, Objects.requireNonNull(map.get(key)));
        }
        return this;
    }

    @CanIgnoreReturnValue
    public <K> TypedMapBuilder put(TypedMap.Key<K> key, K value) {
        this.builder.put(key, value);
        return this;
    }

    public TypedMap build() {
        if (this.builder.isEmpty()) {
            return TypedMap.EMPTY;
        }
        return new BackedTypedMap(Map.copyOf(this.builder));
    }

    private TypedMapBuilder() {
    }

    public static TypedMapBuilder builder() {
        return new TypedMapBuilder();
    }
}

