/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.framework.network.message.IMessage;
import com.mrcrayfish.furniture.refurbished.blockentity.ElectricityModuleBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.IComputer;
import com.mrcrayfish.furniture.refurbished.computer.Computer;
import com.mrcrayfish.furniture.refurbished.computer.Program;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.inventory.BuildableContainerData;
import com.mrcrayfish.furniture.refurbished.inventory.ComputerMenu;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageComputerState;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class ComputerBlockEntity
extends ElectricityModuleBlockEntity
implements MenuProvider,
IComputer {
    public static final int DATA_POWERED = 0;
    public static final int DATA_SYSTEM = 1;
    public static final int DATA_PROGRAM_1 = 2;
    public static final int DATA_PROGRAM_2 = 3;
    protected int systemData;
    protected int programData1;
    protected int programData2;
    protected Program currentProgram;
    @Nullable
    protected Player currentUser;
    protected final ContainerData data = new BuildableContainerData(builder -> {
        builder.add(0, () -> this.isNodePowered() ? 1 : 0, value -> {});
        builder.add(1, () -> this.systemData, value -> {});
        builder.add(2, () -> this.programData1, value -> {
            this.programData1 = value;
        });
        builder.add(3, () -> this.programData2, value -> {
            this.programData2 = value;
        });
    });

    public ComputerBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.COMPUTER.get(), pos, state);
    }

    public ComputerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public BlockPos getComputerPos() {
        return this.f_58858_;
    }

    @Override
    public void setUser(@Nullable Player player) {
        this.currentUser = player;
    }

    @Override
    @Nullable
    public Player getUser() {
        if (this.currentUser != null && (!this.currentUser.m_6084_() || this.currentUser.m_213877_())) {
            this.currentUser = null;
        }
        return this.currentUser;
    }

    @Override
    @Nullable
    public Program getProgram() {
        return this.currentProgram;
    }

    @Override
    @Nullable
    public ComputerMenu getMenu() {
        ComputerMenu menu;
        AbstractContainerMenu abstractContainerMenu;
        Player player = this.getUser();
        if (player != null && (abstractContainerMenu = player.f_36096_) instanceof ComputerMenu && (menu = (ComputerMenu)abstractContainerMenu).getComputer() == this) {
            return menu;
        }
        return null;
    }

    @Override
    public boolean isServer() {
        return this.f_58857_ != null && !this.f_58857_.m_5776_();
    }

    @Override
    public boolean isValid(Player player) {
        return this.isNodePowered() && Container.m_272074_((BlockEntity)this, (Player)player) && player.equals((Object)this.getUser());
    }

    @Override
    public boolean isNodePowered() {
        BlockState state = this.m_58900_();
        return state.m_61138_((Property)BlockStateProperties.f_61448_) && (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_) != false;
    }

    @Override
    public void setNodePowered(boolean powered) {
        BlockState state = this.m_58900_();
        if (state.m_61138_((Property)BlockStateProperties.f_61448_)) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(powered)), 3);
        }
    }

    public Component m_5446_() {
        return Utils.translation("container", "computer", new Object[0]);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new ComputerMenu(windowId, playerInventory, this.data, this);
    }

    public boolean isBeingUsed() {
        ComputerMenu menu;
        AbstractContainerMenu abstractContainerMenu;
        return this.currentUser != null && this.currentUser.m_6084_() && (abstractContainerMenu = this.currentUser.f_36096_) instanceof ComputerMenu && this.currentUser.equals((Object)(menu = (ComputerMenu)abstractContainerMenu).getComputer().getUser());
    }

    @Override
    public void launchProgram(@Nullable ResourceLocation id) {
        if (id == null) {
            if (this.currentProgram != null) {
                this.currentProgram.onClose(true);
            }
            this.currentProgram = null;
            this.syncStateToCurrentUser();
            return;
        }
        if (this.currentProgram != null && this.currentProgram.getId().equals((Object)id)) {
            return;
        }
        Computer.get().createProgramInstance(id, this).ifPresent(program -> {
            this.currentProgram = program;
            this.syncStateToCurrentUser();
        });
    }

    public void syncStateToCurrentUser() {
        Player player = this.getUser();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            this.syncStateToPlayer((Player)player2);
        }
    }

    public void syncStateToPlayer(Player player) {
        ResourceLocation programId = this.currentProgram != null ? this.currentProgram.getId() : null;
        Network.getPlay().sendToPlayer(() -> (ServerPlayer)player, (IMessage)new MessageComputerState(this.f_58858_, programId));
    }

    private void tickProgram() {
        if (this.currentProgram != null) {
            this.currentProgram.tick();
        }
    }

    @Override
    public void moduleTick(Level level) {
        super.moduleTick(level);
        if (!level.f_46443_) {
            this.tickProgram();
        }
    }

    private void setPowerState(boolean powered) {
        this.systemData |= powered ? 1 : 0;
    }

    private void setStartupTime(int time) {
        this.systemData |= time << 16;
    }
}

