/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.polymorph.common.util;

import com.illusivesoulworks.polymorph.api.common.capability.IBlockEntityRecipeData;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BlockEntityTicker {
    private static final Map<BlockEntity, IBlockEntityRecipeData> TICKABLE_BLOCKS = new ConcurrentHashMap<BlockEntity, IBlockEntityRecipeData>();

    public static void tick() {
        ArrayList<BlockEntity> toRemove = new ArrayList<BlockEntity>();
        for (Map.Entry<BlockEntity, IBlockEntityRecipeData> entry : TICKABLE_BLOCKS.entrySet()) {
            BlockEntity be = entry.getKey();
            if (be.m_58901_() || be.m_58904_() == null || be.m_58904_().m_5776_()) {
                toRemove.add(be);
                continue;
            }
            entry.getValue().tick();
        }
        for (BlockEntity be : toRemove) {
            TICKABLE_BLOCKS.remove(be);
        }
    }

    public static void add(ServerPlayer serverPlayer, IBlockEntityRecipeData recipeData) {
        IBlockEntityRecipeData data = TICKABLE_BLOCKS.get(recipeData.getOwner());
        if (data != null) {
            data.addListener(serverPlayer);
        } else {
            recipeData.addListener(serverPlayer);
            TICKABLE_BLOCKS.put((BlockEntity)recipeData.getOwner(), recipeData);
        }
    }

    public static void remove(ServerPlayer serverPlayer) {
        ArrayList<BlockEntity> toRemove = new ArrayList<BlockEntity>();
        for (Map.Entry<BlockEntity, IBlockEntityRecipeData> entry : TICKABLE_BLOCKS.entrySet()) {
            entry.getValue().removeListener(serverPlayer);
            if (!entry.getValue().getListeners().isEmpty()) continue;
            toRemove.add(entry.getKey());
        }
        for (BlockEntity blockEntity : toRemove) {
            TICKABLE_BLOCKS.remove(blockEntity);
        }
    }

    public static void clear() {
        TICKABLE_BLOCKS.clear();
    }
}

