/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.fluid;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.modifiers.fluid.TimeAction;
import slimeknights.tconstruct.library.modifiers.fluid.block.MobEffectCloudFluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.entity.MobEffectFluidEffect;

public record FluidMobEffect(MobEffect effect, int time, int level, @Nullable List<Item> curativeItems) {
    public static final RecordLoadable<FluidMobEffect> LOADABLE = RecordLoadable.create((RecordField)Loadables.MOB_EFFECT.requiredField("effect", e -> e.effect), (RecordField)IntLoadable.FROM_ONE.requiredField("time", e -> e.time), (RecordField)IntLoadable.FROM_ONE.defaultField("level", (Object)1, true, e -> e.level), (RecordField)Loadables.ITEM.list(0).nullableField("curative_items", e -> e.curativeItems), FluidMobEffect::new);

    public int amplifier() {
        return this.level - 1;
    }

    public MobEffectInstance effectWithTime(int time) {
        MobEffectInstance instance = new MobEffectInstance(this.effect, time, this.level - 1);
        if (this.curativeItems != null) {
            instance.setCurativeItems(this.curativeItems.stream().map(ItemStack::new).collect(Collectors.toList()));
        }
        return instance;
    }

    public MobEffectInstance makeEffect(float scale) {
        return this.effectWithTime((int)((float)this.time * scale));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final ImmutableList.Builder<FluidMobEffect> effects = ImmutableList.builder();

        private Builder() {
        }

        public Builder effectCure(MobEffect effect, int time, int level, Item ... curativeItems) {
            this.effects.add((Object)new FluidMobEffect(effect, time, level, List.of(curativeItems)));
            return this;
        }

        public Builder effect(MobEffect effect, int time, int level) {
            this.effects.add((Object)new FluidMobEffect(effect, time, level, null));
            return this;
        }

        public Builder effect(MobEffect effect, int time) {
            return this.effect(effect, time, 1);
        }

        private List<FluidMobEffect> getEffects() {
            ImmutableList effects = this.effects.build();
            if (effects.isEmpty()) {
                throw new IllegalStateException("Must have at least one effect");
            }
            return effects;
        }

        public MobEffectCloudFluidEffect buildCloud() {
            return new MobEffectCloudFluidEffect(this.getEffects());
        }

        public List<MobEffectFluidEffect> buildEntity(TimeAction action) {
            return this.getEffects().stream().map(effect -> new MobEffectFluidEffect((FluidMobEffect)effect, action)).toList();
        }
    }
}

