/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.hook.ranged;

import java.util.function.Predicate;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.TinkerModifiers;

public interface BowAmmoModifierHook {
    public static final BowAmmoModifierHook EMPTY = (tool, modifier, shooter, standardAmmo, ammoPredicate) -> ItemStack.f_41583_;

    public ItemStack findAmmo(IToolStackView var1, ModifierEntry var2, LivingEntity var3, ItemStack var4, Predicate<ItemStack> var5);

    default public void shrinkAmmo(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, ItemStack ammo, int needed) {
        ammo.m_41774_(needed);
    }

    public static boolean hasAmmo(IToolStackView tool, ItemStack bowStack, Player player, Predicate<ItemStack> predicate) {
        if (!player.m_6298_(bowStack).m_41619_()) {
            return true;
        }
        for (ModifierEntry entry : tool.getModifierList()) {
            if (entry.getHook(ModifierHooks.BOW_AMMO).findAmmo(tool, entry, (LivingEntity)player, ItemStack.f_41583_, predicate).m_41619_()) continue;
            return true;
        }
        return false;
    }

    private static ItemStack findMatchingAmmo(ItemStack bow, LivingEntity living, Predicate<ItemStack> predicate) {
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = living.m_21120_(hand);
            if (stack == bow || !predicate.test(stack)) continue;
            return ForgeHooks.getProjectile((LivingEntity)living, (ItemStack)bow, (ItemStack)stack);
        }
        if (living instanceof Player) {
            Player player = (Player)living;
            Inventory inventory = player.m_150109_();
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                ItemStack stack = inventory.m_8020_(i);
                if (stack.m_41619_() || !predicate.test(stack)) continue;
                return ForgeHooks.getProjectile((LivingEntity)player, (ItemStack)bow, (ItemStack)stack);
            }
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack findAmmo(IToolStackView tool, ItemStack bow, Player player, Predicate<ItemStack> predicate) {
        int projectilesDesired = 1 + 2 * tool.getModifierLevel(TinkerModifiers.multishot.getId());
        Level level = player.m_9236_();
        boolean creative = player.m_150110_().f_35937_ || level.f_46443_;
        ItemStack standardAmmo = player.m_6298_(bow);
        ItemStack resultStack = ItemStack.f_41583_;
        for (ModifierEntry modifierEntry : tool.getModifierList()) {
            BowAmmoModifierHook hook = modifierEntry.getHook(ModifierHooks.BOW_AMMO);
            ItemStack ammo = hook.findAmmo(tool, modifierEntry, (LivingEntity)player, standardAmmo, predicate);
            if (ammo.m_41619_()) continue;
            if (creative) {
                return ItemHandlerHelper.copyStackWithSize((ItemStack)ammo, (int)projectilesDesired);
            }
            resultStack = ItemHandlerHelper.copyStackWithSize((ItemStack)ammo, (int)Math.min(projectilesDesired, ammo.m_41613_()));
            hook.shrinkAmmo(tool, modifierEntry, (LivingEntity)player, ammo, resultStack.m_41613_());
            break;
        }
        if (resultStack.m_41619_()) {
            if (standardAmmo.m_41619_()) {
                return ItemStack.f_41583_;
            }
            if (creative) {
                return ItemHandlerHelper.copyStackWithSize((ItemStack)standardAmmo, (int)projectilesDesired);
            }
            resultStack = standardAmmo.m_41620_(projectilesDesired);
            if (standardAmmo.m_41619_()) {
                player.m_150109_().m_36057_(standardAmmo);
            }
        }
        if (resultStack.m_41613_() >= projectilesDesired || level.f_46443_) {
            return resultStack;
        }
        ItemStack match = resultStack;
        predicate = stack -> ItemStack.m_150942_((ItemStack)stack, (ItemStack)match);
        block1: do {
            if (standardAmmo.m_41619_()) {
                standardAmmo = BowAmmoModifierHook.findMatchingAmmo(bow, (LivingEntity)player, predicate);
            }
            for (ModifierEntry entry : tool.getModifierList()) {
                BowAmmoModifierHook hook = entry.getHook(ModifierHooks.BOW_AMMO);
                ItemStack ammo = hook.findAmmo(tool, entry, (LivingEntity)player, standardAmmo, predicate);
                if (ammo.m_41619_()) continue;
                hook.shrinkAmmo(tool, entry, (LivingEntity)player, ammo, Math.min(projectilesDesired - resultStack.m_41613_(), ammo.m_41613_()));
                continue block1;
            }
            if (standardAmmo.m_41619_()) break;
            int n = projectilesDesired - resultStack.m_41613_();
            if (n <= standardAmmo.m_41613_()) {
                resultStack.m_41769_(standardAmmo.m_41613_());
                player.m_150109_().m_36057_(standardAmmo);
                continue;
            }
            standardAmmo.m_41774_(n);
            resultStack.m_41769_(n);
            break;
        } while (resultStack.m_41613_() < projectilesDesired);
        return resultStack;
    }
}

