/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.module.material;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import slimeknights.mantle.data.loadable.IAmLoadable;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.mapping.EitherLoadable;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.IRepairableMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.definition.module.ToolModule;
import slimeknights.tconstruct.library.tools.definition.module.material.MaterialRepairToolHook;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.modules.ArmorModuleBuilder;

public class MaterialRepairModule
implements MaterialRepairToolHook,
ToolModule,
IAmLoadable.Record {
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ToolHooks.MATERIAL_REPAIR);
    private static final LoadableField<MaterialId, MaterialRepairModule> MATERIAL_FIELD = MaterialId.PARSER.requiredField("material", m -> m.material);
    private static final RecordLoadable<MaterialRepairModule> CONSTANT = RecordLoadable.create(MATERIAL_FIELD, (RecordField)IntLoadable.FROM_ONE.requiredField("durability", MaterialRepairModule::getRepairAmount), MaterialRepairModule::new);
    private static final RecordLoadable<StatType> STAT_TYPE = RecordLoadable.create(MATERIAL_FIELD, (RecordField)MaterialStatsId.PARSER.requiredField("stat_type", m -> m.statType), MaterialRepairModule::of);
    public static final RecordLoadable<MaterialRepairModule> LOADER = EitherLoadable.record().key("durability", CONSTANT).key("stat_type", STAT_TYPE).build(CONSTANT);
    protected final MaterialId material;
    protected int repairAmount;

    protected MaterialRepairModule(MaterialId material, int repairAmount) {
        this.material = material;
        this.repairAmount = repairAmount;
    }

    public static MaterialRepairModule of(MaterialId material, int repairAmount) {
        return new MaterialRepairModule(material, repairAmount);
    }

    public static MaterialRepairModule of(MaterialId material, ArmorItem.Type slot, float durabilityFactor) {
        return new MaterialRepairModule(material, (int)((float)ArmorModuleBuilder.MAX_DAMAGE_ARRAY[slot.ordinal()] * durabilityFactor));
    }

    public static StatType of(MaterialId material, MaterialStatsId statType) {
        return new StatType(material, statType);
    }

    public static ArmorBuilder armor(MaterialId material) {
        return new ArmorBuilder(material);
    }

    public RecordLoadable<? extends MaterialRepairModule> loadable() {
        return CONSTANT;
    }

    @Override
    public boolean isRepairMaterial(IToolStackView tool, MaterialId material) {
        return this.material.equals(material);
    }

    @Override
    public float getRepairAmount(IToolStackView tool, MaterialId material) {
        return this.material.equals(material) ? (float)this.repairAmount : 0.0f;
    }

    public RecordLoadable<MaterialRepairModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    public static int getDurability(@Nullable ResourceLocation toolId, MaterialId material, MaterialStatsId statType) {
        IMaterialStats stats = MaterialRegistry.getInstance().getMaterialStats(material, statType).orElse(null);
        if (stats instanceof IRepairableMaterialStats) {
            IRepairableMaterialStats repairable = (IRepairableMaterialStats)stats;
            return repairable.durability();
        }
        if (toolId != null) {
            TConstruct.LOG.warn("Attempting to repair {} using {}, but stat type {}{}. This usually indicates a broken datapack.", (Object)toolId, (Object)material, (Object)statType, (Object)(stats == null ? " does not exist for the material" : " does not contain durability"));
        }
        return 0;
    }

    protected int getRepairAmount() {
        return this.repairAmount;
    }

    private static class StatType
    extends MaterialRepairModule {
        private final MaterialStatsId statType;

        public StatType(MaterialId material, MaterialStatsId statType) {
            super(material, -1);
            this.statType = statType;
        }

        public RecordLoadable<StatType> loadable() {
            return STAT_TYPE;
        }

        @Override
        public float getRepairAmount(IToolStackView tool, MaterialId material) {
            return this.material.equals(material) ? (float)this.getRepairAmount(tool.getDefinition().getId()) : 0.0f;
        }

        private int getRepairAmount(@Nullable ResourceLocation toolId) {
            if (this.repairAmount == -1) {
                this.repairAmount = StatType.getDurability(toolId, this.material, this.statType);
            }
            return this.repairAmount;
        }

        @Override
        protected int getRepairAmount() {
            return this.getRepairAmount(null);
        }
    }

    public static class ArmorBuilder
    implements ArmorModuleBuilder<MaterialRepairModule> {
        private final MaterialId material;
        private final int[] durability = new int[4];

        public ArmorBuilder durabilityFactor(float maxDamageFactor) {
            for (ArmorItem.Type slotType : ArmorItem.Type.values()) {
                int index = slotType.ordinal();
                this.durability[index] = (int)((float)ArmorModuleBuilder.MAX_DAMAGE_ARRAY[index] * maxDamageFactor);
            }
            return this;
        }

        @Override
        public MaterialRepairModule build(ArmorItem.Type slot) {
            return new MaterialRepairModule(this.material, this.durability[slot.ordinal()]);
        }

        private ArmorBuilder(MaterialId material) {
            this.material = material;
        }
    }
}

