/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.partbuilder;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;

public class MaterialItemList {
    private static List<MaterialRecipe> RECIPE_LIST = Collections.emptyList();
    private static final Map<MaterialVariantId, List<ItemStack>> ITEM_LISTS = new HashMap<MaterialVariantId, List<ItemStack>>();

    public static void setRecipes(List<MaterialRecipe> recipes) {
        RECIPE_LIST = recipes.stream().filter(r -> !r.getMaterial().isUnknown()).collect(Collectors.toList());
        ITEM_LISTS.clear();
    }

    public static List<ItemStack> getItems(MaterialVariantId material) {
        ImmutableList list = ITEM_LISTS.get(material);
        if (list == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (MaterialRecipe recipe : RECIPE_LIST) {
                if (!material.matchesVariant(recipe.getMaterial())) continue;
                builder.addAll(recipe.getDisplayItems());
            }
            list = builder.build();
            ITEM_LISTS.put(material, (List<ItemStack>)list);
        }
        return list;
    }
}

