/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.tools.helper.TooltipUtil;
import slimeknights.tconstruct.library.tools.part.IRepairKitItem;
import slimeknights.tconstruct.library.tools.part.MaterialItem;
import slimeknights.tconstruct.library.tools.part.ToolPartItem;
import slimeknights.tconstruct.tools.stats.StatlessMaterialStats;

public class RepairKitItem
extends MaterialItem
implements IRepairKitItem {
    private final float repairAmount;

    public RepairKitItem(Item.Properties properties, float repairAmount) {
        super(properties);
        this.repairAmount = repairAmount;
    }

    public RepairKitItem(Item.Properties properties) {
        this(properties, 0.0f);
    }

    @Override
    public boolean canUseMaterial(MaterialId material) {
        return MaterialRegistry.getInstance().getAllStats(material).stream().anyMatch(stats -> stats == StatlessMaterialStats.REPAIR_KIT || stats.getType().canRepair());
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flag) {
        MaterialVariantId materialVariant;
        if (flag.m_7050_() && !TooltipUtil.isDisplay(stack) && !(materialVariant = this.getMaterial(stack)).equals(IMaterial.UNKNOWN_ID)) {
            tooltip.add((Component)Component.m_237110_((String)ToolPartItem.MATERIAL_KEY, (Object[])new Object[]{materialVariant.toString()}).m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    @Override
    public float getRepairAmount() {
        if (this.repairAmount == 0.0f) {
            return ((Double)Config.COMMON.repairKitAmount.get()).floatValue();
        }
        return this.repairAmount;
    }
}

