/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.client.animation.accessors;

import immersive_melodies.item.InstrumentItem;
import java.util.Optional;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;

public interface ModelAccessor<T extends Entity> {
    public T getEntity();

    private boolean isInMainHand() {
        T t = this.getEntity();
        if (t instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)t;
            return livingEntity.m_21205_().m_41720_() instanceof InstrumentItem;
        }
        return true;
    }

    default public boolean flipHands() {
        return this.isInMainHand() == this.isLeftHanded();
    }

    default public boolean isLeftHanded() {
        LivingEntity livingEntity;
        T t = this.getEntity();
        return t instanceof LivingEntity && (livingEntity = (LivingEntity)t).m_5737_() == HumanoidArm.LEFT;
    }

    default public Optional<ModelPart> getHead() {
        return Optional.empty();
    }

    default public Optional<ModelPart> getHat() {
        return Optional.empty();
    }

    default public Optional<ModelPart> getFlippedLeftArm() {
        return this.flipHands() ? this.getRightArm() : this.getLeftArm();
    }

    default public Optional<ModelPart> getFlippedRightArm() {
        return this.flipHands() ? this.getLeftArm() : this.getRightArm();
    }

    default public Optional<ModelPart> getLeftArm() {
        return Optional.empty();
    }

    default public Optional<ModelPart> getRightArm() {
        return Optional.empty();
    }

    default public float headYaw() {
        return this.getHead().map(h -> Float.valueOf(h.f_104204_)).orElse(Float.valueOf(0.0f)).floatValue();
    }

    default public void headYaw(float yaw) {
        this.getHead().ifPresent(h -> {
            h.f_104204_ = this.flipHands() ? -yaw : yaw;
        });
        this.getHat().ifPresent(h -> {
            h.f_104204_ = this.flipHands() ? -yaw : yaw;
        });
    }

    default public float headPitch() {
        return this.getHead().map(h -> Float.valueOf(h.f_104203_)).orElse(Float.valueOf(0.0f)).floatValue();
    }

    default public void headPitch(float pitch) {
        this.getHead().ifPresent(h -> {
            h.f_104203_ = pitch;
        });
        this.getHat().ifPresent(h -> {
            h.f_104203_ = pitch;
        });
    }

    default public float leftArmYaw() {
        return this.getFlippedLeftArm().map(l -> Float.valueOf(l.f_104204_)).orElse(Float.valueOf(0.0f)).floatValue();
    }

    default public void leftArmYaw(float yaw) {
        this.getFlippedLeftArm().ifPresent(l -> {
            l.f_104204_ = this.flipHands() ? -yaw : yaw;
        });
    }

    default public float leftArmPitch() {
        return this.getFlippedLeftArm().map(l -> Float.valueOf(l.f_104203_)).orElse(Float.valueOf(0.0f)).floatValue();
    }

    default public void leftArmPitch(float pitch) {
        this.getFlippedLeftArm().ifPresent(l -> {
            l.f_104203_ = pitch;
        });
    }

    default public float leftArmRoll() {
        return this.getFlippedLeftArm().map(l -> Float.valueOf(l.f_104205_)).orElse(Float.valueOf(0.0f)).floatValue();
    }

    default public void leftArmRoll(float roll) {
        this.getFlippedLeftArm().ifPresent(l -> {
            l.f_104205_ = this.flipHands() ? -roll : roll;
        });
    }

    default public float rightArmYaw() {
        return this.getFlippedRightArm().map(r -> Float.valueOf(r.f_104204_)).orElse(Float.valueOf(0.0f)).floatValue();
    }

    default public void rightArmYaw(float yaw) {
        this.getFlippedRightArm().ifPresent(r -> {
            r.f_104204_ = this.flipHands() ? -yaw : yaw;
        });
    }

    default public float rightArmPitch() {
        return this.getFlippedRightArm().map(r -> Float.valueOf(r.f_104203_)).orElse(Float.valueOf(0.0f)).floatValue();
    }

    default public void rightArmPitch(float pitch) {
        this.getFlippedRightArm().ifPresent(r -> {
            r.f_104203_ = pitch;
        });
    }

    default public float rightArmRoll() {
        return this.getFlippedRightArm().map(r -> Float.valueOf(r.f_104205_)).orElse(Float.valueOf(0.0f)).floatValue();
    }

    default public void rightArmRoll(float roll) {
        this.getFlippedRightArm().ifPresent(r -> {
            r.f_104205_ = this.flipHands() ? -roll : roll;
        });
    }
}

