/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.resources;

import immersive_melodies.resources.MelodyDescriptor;
import immersive_melodies.resources.Note;
import immersive_melodies.resources.Track;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;

public class Melody
extends MelodyDescriptor {
    static final Melody DEFAULT = new Melody();
    private final List<Track> tracks = new LinkedList<Track>();
    private Track primaryTrack;

    public Melody() {
        super("unknown");
        this.addTrack(new Track("unknown", new LinkedList<Note>()));
    }

    public Melody(String name) {
        super(name);
    }

    public Melody(FriendlyByteBuf b) {
        super(b);
        int trackCount = b.readInt();
        for (int i = 0; i < trackCount; ++i) {
            this.tracks.add(new Track(b));
        }
    }

    public List<Track> getTracks() {
        return Collections.unmodifiableList(this.tracks);
    }

    public int getLength() {
        int length = 0;
        for (Track track : this.tracks) {
            length = Math.max(length, track.getLength());
        }
        return length;
    }

    public void addTrack(Track track) {
        this.tracks.add(track);
        this.primaryTrack = null;
    }

    public Track getPrimaryTrack() {
        if (this.primaryTrack == null) {
            this.primaryTrack = this.getTracks().stream().max(Comparator.comparingInt(m -> (int)((long)m.getNotes().size() * m.getNotes().stream().mapToInt(Note::getNote).distinct().count()))).orElse(Melody.DEFAULT.tracks.get(0));
        }
        return this.primaryTrack;
    }

    public void encode(FriendlyByteBuf b) {
        super.encodeLite(b);
        b.writeInt(this.tracks.size());
        for (Track note : this.tracks) {
            note.encode(b);
        }
    }
}

