/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration.part;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.raytracer.VoxelShapeCache;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.part.face.FaceMicroblockPart;
import codechicken.multipart.api.MultipartType;
import codechicken.multipart.api.part.BaseMultipart;
import codechicken.multipart.api.part.FacePart;
import codechicken.multipart.api.part.IconHitEffectsPart;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.NormalOcclusionPart;
import codechicken.multipart.api.part.TickablePart;
import codechicken.multipart.block.TileMultipart;
import codechicken.multipart.util.MultipartPlaceContext;
import codechicken.multipart.util.PartRayTraceResult;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.LinkedList;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.api.IScrewdriver;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.core.PlacementLib;
import mrtjp.projectred.core.part.IConnectableFacePart;
import mrtjp.projectred.core.part.IOrientableFacePart;
import mrtjp.projectred.integration.GateType;
import mrtjp.projectred.integration.client.GateComponentModels;
import mrtjp.projectred.integration.part.IGateRenderData;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class GatePart
extends BaseMultipart
implements IConnectableFacePart,
IOrientableFacePart,
TickablePart,
FacePart,
NormalOcclusionPart,
IconHitEffectsPart,
IGateRenderData {
    private static final int KEY_UPDATE = 0;
    private static final int KEY_ORIENTATION = 1;
    private static final int KEY_SHAPE = 2;
    private static final Cuboid6[][] oBoxes = new Cuboid6[6][2];
    private static final VoxelShape[] oShapes = new VoxelShape[6];
    private final GateType type;
    private byte orientation = 0;
    private byte gateShape = 0;
    private int connMap = 0;
    private long scheduledTime = 0L;

    public GatePart(GateType type) {
        this.type = type;
    }

    public boolean preparePlacement(MultipartPlaceContext context) {
        int side = context.m_43719_().ordinal();
        this.setSide(side ^ 1);
        this.setRotation(context.m_43723_() == null ? 0 : (Rotation.getSidedRotation((Player)context.m_43723_(), (int)side) + 2) % 4);
        return true;
    }

    public final GateType getGateType() {
        return this.type;
    }

    @Override
    public int getOrientation() {
        return this.orientation & 0xFF;
    }

    @Override
    public int getRenderIndex() {
        return this.type.ordinal();
    }

    @Override
    public int shape() {
        return this.gateShape;
    }

    public void setShape(int gateShape) {
        this.gateShape = (byte)gateShape;
    }

    public int getConnMap() {
        return this.connMap;
    }

    public void setConnMap(int map) {
        this.connMap = map;
    }

    public int getSide() {
        return this.orientation >> 2;
    }

    public int getRotation() {
        return this.orientation & 3;
    }

    public void setSide(int s) {
        this.orientation = (byte)(this.orientation & 3 | s << 2);
    }

    public void setRotation(int r) {
        this.orientation = (byte)(this.orientation & 0xFC | r & 3);
    }

    public void save(CompoundTag tag) {
        super.save(tag);
        tag.m_128344_("orient", this.orientation);
        tag.m_128344_("shape", this.gateShape);
        tag.m_128405_("connMap", this.connMap);
        tag.m_128356_("schedTime", this.scheduledTime);
    }

    public void load(CompoundTag tag) {
        super.load(tag);
        this.orientation = tag.m_128445_("orient");
        this.gateShape = tag.m_128445_("shape");
        this.connMap = tag.m_128451_("connMap");
        this.scheduledTime = tag.m_128454_("schedTime");
    }

    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        packet.writeByte((int)this.orientation);
        packet.writeByte((int)this.gateShape);
    }

    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        this.orientation = packet.readByte();
        this.gateShape = packet.readByte();
    }

    public final void sendUpdate(Consumer<MCDataOutput> func) {
        this.sendUpdate(0, func);
    }

    public final void readUpdate(MCDataInput packet) {
        this.read(packet, packet.readUByte());
    }

    protected final void sendUpdate(int key, Consumer<MCDataOutput> func) {
        super.sendUpdate(p -> {
            p.writeByte(key);
            func.accept((MCDataOutput)p);
        });
    }

    protected void read(MCDataInput packet, int key) {
        switch (key) {
            case 0: {
                this.readDesc(packet);
                break;
            }
            case 1: {
                this.orientation = packet.readByte();
                if (!Configurator.staticGates) break;
                this.tile().markRender();
                break;
            }
            case 2: {
                this.gateShape = packet.readByte();
                if (!Configurator.staticGates) break;
                this.tile().markRender();
                break;
            }
        }
    }

    protected void sendShapeUpdate() {
        this.sendUpdate(2, p -> p.writeByte((int)this.gateShape));
    }

    protected void sendOrientationUpdate() {
        this.sendUpdate(1, p -> p.writeByte((int)this.orientation));
    }

    public void onPartChanged(@Nullable MultiPart part) {
        super.onPartChanged(part);
        if (!this.level().f_46443_) {
            this.updateOutward();
            this.onChange();
        }
    }

    public void onNeighborBlockChanged(BlockPos from) {
        super.onNeighborBlockChanged(from);
        if (!this.level().f_46443_) {
            if (this.dropIfCantStay()) {
                return;
            }
            this.updateOutside();
            this.onChange();
        }
    }

    public void onAdded() {
        super.onAdded();
        if (!this.level().f_46443_) {
            this.gateLogicSetup();
            this.updateInsideAndOutside();
            this.onChange();
        }
    }

    public void onRemoved() {
        super.onRemoved();
        if (!this.level().f_46443_) {
            this.notifyAllExternals();
        }
    }

    public void onChunkLoad(LevelChunk chunk) {
        super.onChunkLoad(chunk);
        if (this.hasTile()) {
            this.gateLogicOnWorldLoad();
        }
    }

    private boolean dropIfCantStay() {
        if (!PlacementLib.canPlaceGateOnSide((Level)this.level(), (BlockPos)this.pos().m_121945_(Direction.values()[this.getSide()]), (Direction)Direction.values()[this.getSide() ^ 1])) {
            TileMultipart.dropItem((ItemStack)this.getGateType().makeStack(), (Level)this.level(), (Vector3)Vector3.fromTileCenter((BlockEntity)this.tile()));
            this.tile().remPart((MultiPart)this);
            return true;
        }
        return false;
    }

    protected void onChange() {
        this.processScheduled();
        this.gateLogicOnChange();
    }

    public void maskChangeEvent(boolean internalChange, boolean externalChange) {
    }

    public void scheduledTick() {
        this.gateLogicOnScheduledTick();
    }

    public void scheduleTick(int ticks) {
        if (this.scheduledTime < 0L) {
            this.scheduledTime = this.level().m_46467_() + (long)ticks;
        }
    }

    public boolean isTickScheduled() {
        return this.scheduledTime >= 0L;
    }

    private void processScheduled() {
        if (this.scheduledTime >= 0L && this.level().m_46467_() >= this.scheduledTime) {
            this.scheduledTime = -1L;
            this.scheduledTick();
        }
    }

    public void tick() {
        if (!this.level().f_46443_) {
            this.processScheduled();
        }
        this.gateLogicOnTick();
    }

    public boolean canConnectPart(IConnectable part, int r) {
        return this.gateLogicCanConnectTo(part, this.toInternal(r));
    }

    public boolean setRenderFlag(IConnectable part) {
        return false;
    }

    public boolean discoverOpen(int r) {
        return true;
    }

    public boolean canConnectCorner(int r) {
        return false;
    }

    public MultipartType<?> getType() {
        return this.getGateType().getPartType();
    }

    public ItemStack getCloneStack(PartRayTraceResult hit) {
        return this.getItem();
    }

    public Iterable<ItemStack> getDrops() {
        return Collections.singleton(this.getItem());
    }

    protected ItemStack getItem() {
        return this.getGateType().makeStack();
    }

    public VoxelShape getShape(CollisionContext context) {
        return FaceMicroblockPart.aShapes[0x10 | this.getSide()];
    }

    public VoxelShape getOcclusionShape() {
        return oShapes[this.getSide()];
    }

    public VoxelShape getBlockSupportShape() {
        return Shapes.m_83040_();
    }

    public float getStrength(Player player, PartRayTraceResult hit) {
        return 0.06666667f;
    }

    public int getLightEmission() {
        return Configurator.logicGateLights ? 7 : 0;
    }

    public SoundType getPlacementSound(UseOnContext context) {
        return SoundType.f_56744_;
    }

    public int getSlotMask() {
        return 1 << this.getSide();
    }

    public InteractionResult activate(Player player, PartRayTraceResult hit, ItemStack held, InteractionHand hand) {
        Item item;
        if (this.gateLogicActivate(player, held, hit)) {
            return InteractionResult.SUCCESS;
        }
        if (!held.m_41619_() && (item = held.m_41720_()) instanceof IScrewdriver) {
            IScrewdriver screwdriver = (IScrewdriver)item;
            if (!this.level().f_46443_) {
                if (player.m_6047_()) {
                    this.configure();
                } else {
                    this.rotate();
                }
                screwdriver.damageScrewdriver(player, held);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void configure() {
        if (this.gateLogicCycleShape()) {
            this.updateInsideAndOutside();
            this.tile().m_6596_();
            this.tile().notifyPartChange((MultiPart)this);
            this.sendShapeUpdate();
            this.notifyExternals(15);
            this.onChange();
        }
    }

    protected void rotate() {
        this.setRotation((this.getRotation() + 1) % 4);
        this.updateInsideAndOutside();
        this.tile().m_6596_();
        this.tile().notifyPartChange((MultiPart)this);
        this.sendOrientationUpdate();
        this.notifyExternals(15);
        this.onChange();
    }

    public Cuboid6 getBounds() {
        return new Cuboid6(this.getShape(CollisionContext.m_82749_()).m_83215_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getBreakingIcon(PartRayTraceResult hit) {
        return GateComponentModels.baseIcon.icon;
    }

    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getBrokenIcon(int side) {
        return GateComponentModels.baseIcon.icon;
    }

    protected abstract boolean gateLogicCanConnectTo(IConnectable var1, int var2);

    protected abstract void gateLogicOnChange();

    protected abstract void gateLogicOnScheduledTick();

    protected boolean gateLogicCycleShape() {
        return false;
    }

    protected void gateLogicOnTick() {
    }

    protected void gateLogicSetup() {
    }

    protected void gateLogicOnWorldLoad() {
    }

    protected boolean gateLogicActivate(Player player, ItemStack held, PartRayTraceResult hit) {
        return false;
    }

    static {
        for (int s = 0; s < 6; ++s) {
            Transformation t = Rotation.sideRotations[s].at(Vector3.CENTER);
            Cuboid6 occlusion1 = new Cuboid6(0.125, 0.0, 0.0, 0.875, 0.125, 1.0);
            Cuboid6 occlusion2 = new Cuboid6(0.0, 0.0, 0.125, 1.0, 0.125, 0.875);
            GatePart.oBoxes[s][0] = occlusion1.apply(t);
            GatePart.oBoxes[s][1] = occlusion2.apply(t);
            LinkedList<VoxelShape> boxes = new LinkedList<VoxelShape>();
            for (Cuboid6 box : oBoxes[s]) {
                boxes.add(VoxelShapeCache.getShape((Cuboid6)box));
            }
            GatePart.oShapes[s] = VoxelShapeCache.merge((ImmutableSet)ImmutableSet.copyOf(boxes));
        }
    }
}

