/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.candlelight.core.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashSet;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.satisfy.candlelight.core.block.entity.CStoveBlockEntity;
import net.satisfy.candlelight.core.block.entity.CabinetBlockEntity;
import net.satisfy.candlelight.core.block.entity.CompletionistBannerEntity;
import net.satisfy.candlelight.core.block.entity.CookingPanBlockEntity;
import net.satisfy.candlelight.core.block.entity.DinnerBellBlockEntity;
import net.satisfy.candlelight.core.block.entity.LargeCookingPotBlockEntity;
import net.satisfy.candlelight.core.block.entity.SideBoardBlockEntity;
import net.satisfy.candlelight.core.block.entity.StorageBlockEntity;
import net.satisfy.candlelight.core.block.entity.TableSetBlockEntity;
import net.satisfy.candlelight.core.block.entity.TypeWriterEntity;
import net.satisfy.candlelight.core.registry.ObjectRegistry;
import net.satisfy.candlelight.core.registry.StorageTypeRegistry;
import net.satisfy.candlelight.core.util.CandlelightIdentifier;
import net.satisfy.farm_and_charm.core.block.entity.EffectFoodBlockEntity;

public class EntityTypeRegistry {
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((String)"candlelight", (ResourceKey)Registries.f_256922_);
    private static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((String)"candlelight", (ResourceKey)Registries.f_256939_);
    public static final RegistrySupplier<BlockEntityType<StorageBlockEntity>> STORAGE_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("storage", () -> BlockEntityType.Builder.m_155273_(StorageBlockEntity::new, (Block[])StorageTypeRegistry.registerBlocks(new HashSet<Block>()).toArray(new Block[0])).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<SideBoardBlockEntity>> SIDEBOARD_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("sideboard", () -> BlockEntityType.Builder.m_155273_(SideBoardBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.SIDEBOARD.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<LargeCookingPotBlockEntity>> COOKING_POT_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("cooking_pot", () -> BlockEntityType.Builder.m_155273_(LargeCookingPotBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.COOKING_POT.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<TypeWriterEntity>> TYPE_WRITER_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("type_writer", () -> BlockEntityType.Builder.m_155273_(TypeWriterEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.TYPEWRITER_IRON.get(), (Block)ObjectRegistry.TYPEWRITER_COPPER.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<CookingPanBlockEntity>> COOKING_PAN_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("cooking_pan", () -> BlockEntityType.Builder.m_155273_(CookingPanBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.COOKING_PAN.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<EffectFoodBlockEntity>> EFFECT_FOOD_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("effect_food_block", () -> BlockEntityType.Builder.m_155273_(EffectFoodBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.LASAGNE_BLOCK.get(), (Block)ObjectRegistry.TOMATO_MOZZARELLA_BLOCK.get(), (Block)ObjectRegistry.PORK_RIBS_BLOCK.get(), (Block)ObjectRegistry.FRESH_GARDEN_SALAD_BLOCK.get(), (Block)ObjectRegistry.BEEF_WELLINGTON_BLOCK.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<DinnerBellBlockEntity>> DINNER_BELL_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("dinner_bell", () -> BlockEntityType.Builder.m_155273_(DinnerBellBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.DINNER_BELL.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<CStoveBlockEntity>> STOVE_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("stove_block", () -> BlockEntityType.Builder.m_155273_(CStoveBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.COBBLESTONE_STOVE.get(), (Block)ObjectRegistry.MUD_STOVE.get(), (Block)ObjectRegistry.GRANITE_STOVE.get(), (Block)ObjectRegistry.SANDSTONE_STOVE.get(), (Block)ObjectRegistry.STONE_BRICKS_STOVE.get(), (Block)ObjectRegistry.RED_NETHER_BRICKS_STOVE.get(), (Block)ObjectRegistry.DEEPSLATE_STOVE.get(), (Block)ObjectRegistry.QUARTZ_STOVE.get(), (Block)ObjectRegistry.END_STOVE.get(), (Block)ObjectRegistry.BASALT_STOVE.get(), (Block)ObjectRegistry.BAMBOO_STOVE.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<CabinetBlockEntity>> CABINET_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("cabinet", () -> BlockEntityType.Builder.m_155273_(CabinetBlockEntity::new, (Block[])StorageTypeRegistry.registerBlocks(new HashSet<Block>()).toArray(new Block[0])).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<CompletionistBannerEntity>> CANDLELIGHT_BANNER = EntityTypeRegistry.registerBlockEntity("candlelight_banner", () -> BlockEntityType.Builder.m_155273_(CompletionistBannerEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.CANDLELIGHT_BANNER.get(), (Block)ObjectRegistry.CANDLELIGHT_WALL_BANNER.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<TableSetBlockEntity>> TABLE_SET_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("table_set", () -> BlockEntityType.Builder.m_155273_(TableSetBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.TABLE_SET.get()}).m_58966_(null));

    private static <T extends BlockEntityType<?>> RegistrySupplier<T> registerBlockEntity(String path, Supplier<T> type) {
        return BLOCK_ENTITY_TYPES.register((ResourceLocation)new CandlelightIdentifier(path), type);
    }

    public static void init() {
        ENTITY_TYPES.register();
        BLOCK_ENTITY_TYPES.register();
    }
}

