/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.core;

import gg.moonflower.etched.api.sound.download.SoundSourceManager;
import gg.moonflower.etched.client.screen.AlbumCoverScreen;
import gg.moonflower.etched.client.screen.AlbumJukeboxScreen;
import gg.moonflower.etched.client.screen.BoomboxScreen;
import gg.moonflower.etched.client.screen.EtchingScreen;
import gg.moonflower.etched.client.screen.RadioScreen;
import gg.moonflower.etched.common.item.AlbumCoverItem;
import gg.moonflower.etched.common.item.BoomboxItem;
import gg.moonflower.etched.common.item.EtchedMusicDiscItem;
import gg.moonflower.etched.common.network.EtchedMessages;
import gg.moonflower.etched.common.sound.download.BandcampSource;
import gg.moonflower.etched.common.sound.download.SoundCloudSource;
import gg.moonflower.etched.core.EtchedConfig;
import gg.moonflower.etched.core.registry.EtchedBlocks;
import gg.moonflower.etched.core.registry.EtchedEntities;
import gg.moonflower.etched.core.registry.EtchedItems;
import gg.moonflower.etched.core.registry.EtchedMenus;
import gg.moonflower.etched.core.registry.EtchedRecipes;
import gg.moonflower.etched.core.registry.EtchedSounds;
import gg.moonflower.etched.core.registry.EtchedVillagers;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.GrindstoneEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;

@Mod(value="etched")
public class Etched {
    public static final String MOD_ID = "etched";
    public static final EtchedConfig.Client CLIENT_CONFIG;
    public static final EtchedConfig.Server SERVER_CONFIG;
    private static final ForgeConfigSpec clientSpec;
    private static final ForgeConfigSpec serverSpec;

    public Etched() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(Etched::init);
        bus.addListener(Etched::clientInit);
        EtchedBlocks.BLOCKS.register(bus);
        EtchedBlocks.BLOCK_ENTITIES.register(bus);
        EtchedItems.REGISTRY.register(bus);
        EtchedEntities.REGISTRY.register(bus);
        EtchedMenus.REGISTRY.register(bus);
        EtchedSounds.REGISTRY.register(bus);
        EtchedRecipes.REGISTRY.register(bus);
        EtchedVillagers.POI_REGISTRY.register(bus);
        EtchedVillagers.PROFESSION_REGISTRY.register(bus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)clientSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)serverSpec);
        MinecraftForge.EVENT_BUS.addListener(Etched::onGrindstoneChange);
        MinecraftForge.EVENT_BUS.addListener(Etched::onItemChangedDimension);
    }

    private static void init(FMLCommonSetupEvent event) {
        EtchedMessages.init();
        SoundSourceManager.registerSource(new SoundCloudSource());
        SoundSourceManager.registerSource(new BandcampSource());
        event.enqueueWork(() -> {
            CauldronInteraction.f_175607_.put(EtchedItems.BLANK_MUSIC_DISC.get(), CauldronInteraction.f_175615_);
            CauldronInteraction.f_175607_.put(EtchedItems.MUSIC_LABEL.get(), CauldronInteraction.f_175615_);
            CauldronInteraction.f_175607_.put(EtchedItems.COMPLEX_MUSIC_LABEL.get(), (state, level, pos, player, hand, stack) -> {
                if (!level.m_5776_()) {
                    ItemStack newStack = new ItemStack((ItemLike)EtchedItems.MUSIC_LABEL.get());
                    newStack.m_41764_(stack.m_41613_());
                    if (stack.m_41782_()) {
                        CompoundTag tag = stack.m_41783_().m_6426_();
                        if (tag.m_128425_("Label", 10)) {
                            CompoundTag label = tag.m_128469_("Label");
                            label.m_128473_("PrimaryColor");
                            label.m_128473_("SecondaryColor");
                        }
                        newStack.m_41751_(tag);
                    }
                    player.m_21008_(hand, newStack);
                    player.m_36220_(Stats.f_12945_);
                    LayeredCauldronBlock.m_153559_((BlockState)state, (Level)level, (BlockPos)pos);
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            });
        });
    }

    private static void clientInit(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemProperties.register((Item)EtchedItems.BOOMBOX.get(), (ResourceLocation)new ResourceLocation(MOD_ID, "playing"), (stack, level, entity, i) -> {
                if (!(entity instanceof Player)) {
                    return 0.0f;
                }
                InteractionHand hand = BoomboxItem.getPlayingHand(entity);
                return hand != null && stack == entity.m_21120_(hand) ? 1.0f : 0.0f;
            });
            ItemProperties.register((Item)EtchedItems.ETCHED_MUSIC_DISC.get(), (ResourceLocation)new ResourceLocation(MOD_ID, "pattern"), (stack, level, entity, i) -> (float)EtchedMusicDiscItem.getPattern(stack).ordinal() / 10.0f);
            MenuScreens.m_96206_(EtchedMenus.ETCHING_MENU.get(), EtchingScreen::new);
            MenuScreens.m_96206_(EtchedMenus.ALBUM_JUKEBOX_MENU.get(), AlbumJukeboxScreen::new);
            MenuScreens.m_96206_(EtchedMenus.BOOMBOX_MENU.get(), BoomboxScreen::new);
            MenuScreens.m_96206_(EtchedMenus.ALBUM_COVER_MENU.get(), AlbumCoverScreen::new);
            MenuScreens.m_96206_(EtchedMenus.RADIO_MENU.get(), RadioScreen::new);
        });
    }

    private static void onGrindstoneChange(GrindstoneEvent.OnPlaceItem event) {
        ItemStack stack;
        ItemStack top = event.getTopItem();
        ItemStack bottom = event.getBottomItem();
        if (top.m_41619_() == bottom.m_41619_()) {
            return;
        }
        ItemStack itemStack = stack = top.m_41619_() ? bottom : top;
        if (AlbumCoverItem.getCoverStack(stack).isPresent()) {
            ItemStack result = stack.m_41777_();
            result.m_41764_(1);
            AlbumCoverItem.setCover(result, ItemStack.f_41583_);
            event.setOutput(result);
        }
    }

    private static void onItemChangedDimension(EntityTravelToDimensionEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ItemEntity) {
            ItemEntity entity2 = (ItemEntity)entity;
            if (event.getDimension() == Level.f_46429_) {
                ItemStack oldStack = entity2.m_32055_();
                if (oldStack.m_41720_() != ((Block)EtchedBlocks.RADIO.get()).m_5456_()) {
                    return;
                }
                ItemStack newStack = new ItemStack((ItemLike)EtchedBlocks.PORTAL_RADIO_ITEM.get(), oldStack.m_41613_());
                newStack.m_41751_(oldStack.m_41783_());
                entity2.m_32045_(newStack);
            }
        }
    }

    static {
        Pair clientConfig = new ForgeConfigSpec.Builder().configure(EtchedConfig.Client::new);
        clientSpec = (ForgeConfigSpec)clientConfig.getRight();
        CLIENT_CONFIG = (EtchedConfig.Client)clientConfig.getLeft();
        Pair serverConfig = new ForgeConfigSpec.Builder().configure(EtchedConfig.Server::new);
        serverSpec = (ForgeConfigSpec)serverConfig.getRight();
        SERVER_CONFIG = (EtchedConfig.Server)serverConfig.getLeft();
    }
}

