/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.ritual;

import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.ritual.RangeRitual;
import com.hollingsworth.arsnouveau.common.block.tile.RitualBrazierTile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class RitualEventQueue {
    public static Map<String, Set<BlockPos>> posMap = new HashMap<String, Set<BlockPos>>();

    public static void addPosition(Level world, BlockPos pos) {
        String key = world.m_46472_().m_135782_().toString();
        if (!posMap.containsKey(key)) {
            posMap.put(key, new HashSet());
        }
        posMap.get(key).add(pos);
    }

    public static boolean containsPosition(Level world, BlockPos pos) {
        String key = world.m_46472_().m_135782_().toString();
        if (!posMap.containsKey(key)) {
            return false;
        }
        return posMap.get(key).contains(pos);
    }

    public static <T extends RangeRitual> List<T> getRituals(Level level, Class<T> type) {
        ArrayList<RangeRitual> rituals = new ArrayList<RangeRitual>();
        Set worldList = posMap.getOrDefault(level.m_46472_().m_135782_().toString(), new HashSet());
        ArrayList<BlockPos> stalePos = new ArrayList<BlockPos>();
        for (BlockPos p : worldList) {
            if (!level.m_46749_(p)) continue;
            BlockEntity entity = level.m_7702_(p);
            if (!(entity instanceof RitualBrazierTile)) {
                stalePos.add(p);
                continue;
            }
            RitualBrazierTile brazierTile = (RitualBrazierTile)entity;
            AbstractRitual ritual = brazierTile.ritual;
            if (ritual == null || !ritual.getClass().equals(type)) continue;
            rituals.add((RangeRitual)ritual);
        }
        return rituals;
    }

    @Nullable
    public static <T extends RangeRitual> T getRitual(Level level, Class<T> type, Predicate<T> isMatch) {
        Set worldList = posMap.getOrDefault(level.m_46472_().m_135782_().toString(), new HashSet());
        ArrayList<BlockPos> stalePos = new ArrayList<BlockPos>();
        for (BlockPos p : worldList) {
            if (!level.m_46749_(p)) continue;
            BlockEntity entity = level.m_7702_(p);
            if (!(entity instanceof RitualBrazierTile)) {
                stalePos.add(p);
                continue;
            }
            RitualBrazierTile brazierTile = (RitualBrazierTile)entity;
            AbstractRitual ritual = brazierTile.ritual;
            if (ritual == null || !ritual.getClass().equals(type) || !isMatch.test((RangeRitual)ritual)) continue;
            return (T)((RangeRitual)ritual);
        }
        for (BlockPos p : stalePos) {
            worldList.remove(p);
        }
        return null;
    }
}

