/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.item;

import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.util.CasterUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleLineData;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.client.renderer.ANGeoModel;
import com.hollingsworth.arsnouveau.client.renderer.item.FixedGeoItemRenderer;
import com.hollingsworth.arsnouveau.common.items.SpellBow;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.object.Color;

public class SpellBowRenderer
extends FixedGeoItemRenderer<SpellBow> {
    public SpellBowRenderer() {
        super(new ANGeoModel("geo/spellbow.geo.json", "textures/item/spellbow.png", "animations/wand_animation.json"));
    }

    public void renderRecursively(PoseStack poseStack, SpellBow animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (bone.getName().equals("gem")) {
            super.renderRecursively(poseStack, (Item)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        } else {
            super.renderRecursively(poseStack, (Item)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, (float)Color.WHITE.getRed() / 255.0f, (float)Color.WHITE.getGreen() / 255.0f, (float)Color.WHITE.getBlue() / 255.0f, (float)Color.WHITE.getAlpha() / 255.0f);
        }
    }

    public Color getRenderColor(SpellBow animatable, float partialTick, int packedLight) {
        ParticleColor color = ParticleColor.defaultParticleColor();
        if (this.currentItemStack.m_41782_()) {
            color = animatable.getSpellCaster(this.currentItemStack).getColor();
        }
        return Color.ofRGBA((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), (float)0.75f);
    }

    public void m_108829_(ItemStack itemStack, ItemDisplayContext transformType, PoseStack stack, MultiBufferSource bufferIn, int combinedLightIn, int p_239207_6_) {
        if (transformType == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            Vec3 playerPos = player.m_20182_().m_82520_(0.0, (double)player.m_20192_(), 0.0);
            Vec3 look = player.m_20154_();
            Vec3 right = new Vec3(-look.f_82481_, 0.0, look.f_82479_).m_82541_();
            Vec3 forward = look;
            Vec3 down = right.m_82537_(forward);
            right = right.m_82490_(0.2 - (double)player.f_20921_);
            forward = forward.m_82490_((double)0.45f);
            down = down.m_82490_(-0.1 - (double)player.f_20921_);
            Vec3 laserPos = playerPos.m_82549_(right);
            laserPos = laserPos.m_82549_(forward);
            laserPos = laserPos.m_82549_(down);
            ISpellCaster tool = CasterUtil.getCaster(itemStack);
            int timeHeld = 72000 - Minecraft.m_91087_().f_91074_.m_21212_();
            if (timeHeld > 0 && timeHeld != 72000) {
                float scaleAge = (float)ParticleUtil.inRange(0.05, 0.1);
                if (player.f_19853_.f_46441_.m_188503_(6) == 0) {
                    for (int i = 0; i < 1; ++i) {
                        Vec3 particlePos = new Vec3(laserPos.f_82479_, laserPos.f_82480_, laserPos.f_82481_);
                        particlePos = particlePos.m_82549_(ParticleUtil.pointInSphere().m_82490_((double)0.3f));
                        player.f_19853_.m_7106_(ParticleLineData.createData(tool.getColor(), scaleAge, 5 + player.f_19853_.f_46441_.m_188503_(20)), particlePos.m_7096_(), particlePos.m_7098_(), particlePos.m_7094_(), laserPos.m_7096_(), laserPos.m_7098_(), laserPos.m_7094_());
                    }
                }
            }
        }
        super.m_108829_(itemStack, transformType, stack, bufferIn, combinedLightIn, p_239207_6_);
    }

    public void renderFinal(PoseStack poseStack, SpellBow animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTicks, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        int timeHeld;
        CoreGeoBone top = (CoreGeoBone)model.getBone("bow_top").get();
        CoreGeoBone gem = (CoreGeoBone)model.getBone("gem").get();
        CoreGeoBone bottom = (CoreGeoBone)model.getBone("bow_bot").get();
        double ticks = animatable.getTick(animatable);
        float outerAngle = (float)((ticks + (double)partialTicks) / 10.0 % 360.0);
        top.setRotZ((float)Math.toRadians(-10.0));
        top.setRotY(0.0f);
        top.setRotX(0.0f);
        bottom.setRotZ((float)Math.toRadians(10.0));
        bottom.setRotY(0.0f);
        bottom.setRotX((float)Math.toRadians(-180.0));
        if (Minecraft.m_91087_().f_91074_.m_21205_().equals(this.currentItemStack) && (timeHeld = 72000 - Minecraft.m_91087_().f_91074_.m_21212_()) != 0 && timeHeld != 72000) {
            top.setRotZ((float)(Math.toRadians(-10.0) - Math.toRadians(timeHeld) * 2.0));
            bottom.setRotZ((float)(Math.toRadians(-10.0) + Math.toRadians(timeHeld) * 2.0));
            outerAngle = (float)((ticks + (double)partialTicks) / 5.0 % 360.0);
            if (timeHeld >= 19) {
                top.setRotZ((float)(Math.toRadians(-10.0) - Math.toRadians(19.0) * 2.0));
                bottom.setRotZ((float)(Math.toRadians(-10.0) + Math.toRadians(19.0) * 2.0));
                outerAngle = (float)((ticks + (double)partialTicks) / 3.0 % 360.0);
            }
        }
        gem.setRotX(outerAngle);
        gem.setRotY(outerAngle);
    }

    public RenderType getRenderType(SpellBow animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.m_110473_((ResourceLocation)texture);
    }
}

