/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.armor;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.hollingsworth.arsnouveau.api.client.IVariantColorProvider;
import com.hollingsworth.arsnouveau.api.mana.IManaEquipment;
import com.hollingsworth.arsnouveau.api.perk.ArmorPerkHolder;
import com.hollingsworth.arsnouveau.api.perk.IPerk;
import com.hollingsworth.arsnouveau.api.perk.IPerkHolder;
import com.hollingsworth.arsnouveau.api.perk.IPerkProvider;
import com.hollingsworth.arsnouveau.api.perk.ITickablePerk;
import com.hollingsworth.arsnouveau.api.perk.PerkAttributes;
import com.hollingsworth.arsnouveau.api.perk.PerkInstance;
import com.hollingsworth.arsnouveau.api.registry.PerkRegistry;
import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.hollingsworth.arsnouveau.client.renderer.item.ArmorRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.GenericModel;
import com.hollingsworth.arsnouveau.common.armor.Materials;
import com.hollingsworth.arsnouveau.common.crafting.recipes.IDyeable;
import com.hollingsworth.arsnouveau.common.perk.RepairingPerk;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AnimatedMagicArmor
extends ArmorItem
implements IManaEquipment,
IDyeable,
GeoItem,
IVariantColorProvider<ItemStack> {
    public GeoModel<AnimatedMagicArmor> model;
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public AnimatedMagicArmor(ArmorMaterial materialIn, ArmorItem.Type slot, Item.Properties builder, GeoModel<AnimatedMagicArmor> model) {
        super(materialIn, slot, builder);
        this.model = model;
    }

    public AnimatedMagicArmor(ArmorMaterial materialIn, ArmorItem.Type slot, GeoModel<AnimatedMagicArmor> model) {
        this(materialIn, slot, ItemsRegistry.defaultItemProperties().m_41487_(1), model);
    }

    public static AnimatedMagicArmor light(ArmorItem.Type slot) {
        return new AnimatedMagicArmor(Materials.LIGHT, slot, new GenericModel("light_armor", "item/light_armor").withEmptyAnim());
    }

    public static AnimatedMagicArmor medium(ArmorItem.Type slot) {
        return new AnimatedMagicArmor(Materials.MEDIUM, slot, new GenericModel("medium_armor", "item/medium_armor").withEmptyAnim());
    }

    public static AnimatedMagicArmor heavy(ArmorItem.Type slot) {
        return new AnimatedMagicArmor(Materials.HEAVY, slot, new GenericModel("heavy_armor", "item/heavy_armor").withEmptyAnim());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        if (world.m_5776_()) {
            return;
        }
        RepairingPerk.attemptRepair(stack, player);
        IPerkHolder<ItemStack> perkHolder = PerkUtil.getPerkHolder(stack);
        if (perkHolder == null) {
            return;
        }
        for (PerkInstance instance : perkHolder.getPerkInstances()) {
            IPerk iPerk = instance.getPerk();
            if (!(iPerk instanceof ITickablePerk)) continue;
            ITickablePerk tickablePerk = (ITickablePerk)((Object)iPerk);
            tickablePerk.tick(stack, world, player, instance);
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot pEquipmentSlot, ItemStack stack) {
        ImmutableMultimap.Builder attributes = new ImmutableMultimap.Builder();
        attributes.putAll(super.m_7167_(pEquipmentSlot));
        if (this.f_265916_.m_266308_() == pEquipmentSlot) {
            UUID uuid = (UUID)f_265987_.get(this.f_265916_);
            IPerkHolder<ItemStack> perkHolder = PerkUtil.getPerkHolder(stack);
            if (perkHolder != null) {
                attributes.put((Object)((Attribute)PerkAttributes.MAX_MANA.get()), (Object)new AttributeModifier(uuid, "max_mana_armor", (double)(30 * (perkHolder.getTier() + 1)), AttributeModifier.Operation.ADDITION));
                attributes.put((Object)((Attribute)PerkAttributes.MANA_REGEN_BONUS.get()), (Object)new AttributeModifier(uuid, "mana_regen_armor", (double)(perkHolder.getTier() + 1), AttributeModifier.Operation.ADDITION));
                for (PerkInstance perkInstance : perkHolder.getPerkInstances()) {
                    IPerk perk = perkInstance.getPerk();
                    attributes.putAll(perk.getModifiers(this.f_265916_.m_266308_(), stack, perkInstance.getSlot().value));
                }
            }
        }
        return attributes.build();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        IPerkProvider<ItemStack> perkProvider = PerkRegistry.getPerkProvider(stack.m_41720_());
        if (perkProvider != null) {
            IPerkHolder<ItemStack> iPerkHolder = perkProvider.getPerkHolder(stack);
            if (iPerkHolder instanceof ArmorPerkHolder) {
                ArmorPerkHolder armorPerkHolder = (ArmorPerkHolder)iPerkHolder;
                tooltip.add((Component)Component.m_237110_((String)"ars_nouveau.tier", (Object[])new Object[]{armorPerkHolder.getTier() + 1}).m_130940_(ChatFormatting.GOLD));
            }
            perkProvider.getPerkHolder(stack).appendPerkTooltip(tooltip, stack);
        }
    }

    @Override
    public void onDye(ItemStack stack, DyeColor dyeColor) {
        IPerkHolder<ItemStack> perkHolder = PerkUtil.getPerkHolder(stack);
        if (perkHolder instanceof ArmorPerkHolder) {
            ArmorPerkHolder armorPerkHolder = (ArmorPerkHolder)perkHolder;
            armorPerkHolder.setColor(dyeColor.m_41065_());
        }
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return true;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){
            private GeoArmorRenderer<?> renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new ArmorRenderer(AnimatedMagicArmor.this.getArmorModel());
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public GeoModel<AnimatedMagicArmor> getArmorModel() {
        return this.model;
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        GenericModel genericModel = (GenericModel)this.model;
        return new ResourceLocation("ars_nouveau", "textures/" + genericModel.textPathRoot + "/" + genericModel.name + "_" + this.getColor(stack) + ".png").toString();
    }

    @Override
    public void setColor(String color, ItemStack armor) {
    }

    @Override
    public String getColor(ItemStack object) {
        IPerkHolder<ItemStack> perkHolder = PerkUtil.getPerkHolder(object);
        if (!(perkHolder instanceof ArmorPerkHolder)) {
            return "purple";
        }
        ArmorPerkHolder data = (ArmorPerkHolder)perkHolder;
        return data.getColor() == null || data.getColor().isEmpty() ? "purple" : data.getColor();
    }

    public int getMinTier() {
        return 0;
    }
}

