/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.perk;

import com.hollingsworth.arsnouveau.api.event.SpellCastEvent;
import com.hollingsworth.arsnouveau.api.perk.IEffectResolvePerk;
import com.hollingsworth.arsnouveau.api.perk.IPerk;
import com.hollingsworth.arsnouveau.api.perk.Perk;
import com.hollingsworth.arsnouveau.api.perk.PerkInstance;
import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.hollingsworth.arsnouveau.setup.registry.ModPotions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;

public class ImmolatePerk
extends Perk
implements IEffectResolvePerk {
    public static final ImmolatePerk INSTANCE = new ImmolatePerk(new ResourceLocation("ars_nouveau", "thread_immolation"));

    public ImmolatePerk(ResourceLocation key) {
        super(key);
    }

    @Override
    public void onSpellCast(SpellCastEvent spellCastEvent, PerkInstance perkInstance) {
        LivingEntity caster = spellCastEvent.context.getUnwrappedCaster();
        int level = PerkUtil.countForPerk((IPerk)INSTANCE, caster);
        if (caster.m_6060_()) {
            caster.m_252836_();
            caster.m_7292_(new MobEffectInstance((MobEffect)ModPotions.IMMOLATE_EFFECT.get(), 100, level - 1));
        }
        if (caster.f_19853_.m_8055_(caster.m_20183_()).m_204336_(BlockTags.f_13076_)) {
            caster.f_19853_.m_7471_(caster.m_20183_(), false);
            caster.m_7292_(new MobEffectInstance((MobEffect)ModPotions.IMMOLATE_EFFECT.get(), 100, level - 1));
        }
    }

    @Override
    public String getLangName() {
        return "Immolation";
    }

    @Override
    public String getLangDescription() {
        return "If the user is on fire or standing in fire, the fire will be extinguished when the user casts a spell and will be granted the Immolation potion effect. Fire spells will deal additional damage and last longer for each level of Immolation.";
    }
}

