/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.item.inv.ExtractedStack;
import com.hollingsworth.arsnouveau.api.item.inv.InventoryManager;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.TileCaster;
import com.hollingsworth.arsnouveau.common.datagen.ItemTagProvider;
import com.hollingsworth.arsnouveau.common.lib.GlyphLib;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtract;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentRandomize;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class EffectToss
extends AbstractEffect {
    public static EffectToss INSTANCE = new EffectToss();

    public EffectToss() {
        super(GlyphLib.EffectTossID, "Toss");
    }

    public int getStackSize(SpellStats spellStats) {
        if (spellStats.hasBuff(AugmentExtract.INSTANCE)) {
            return 1;
        }
        double amp = spellStats.getAmpMultiplier();
        return (int)(64.0 * Math.pow(2.0, amp));
    }

    private ExtractedStack extractItem(InventoryManager inventory, Predicate<ItemStack> predicate, int count, boolean randomized) {
        if (randomized) {
            return inventory.extractRandomItem(predicate, count);
        }
        return inventory.extractItem(predicate, count);
    }

    @Override
    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        BlockPos pos = rayTraceResult.m_82443_().m_20183_();
        this.summonStack(shooter, spellContext, spellStats, world, pos, new InventoryManager(spellContext.getCaster()));
    }

    public void processStacks(LivingEntity shooter, SpellContext context, SpellStats spellStats, InventoryManager inventoryManager, Consumer<ExtractedStack> consumer) {
        int size;
        for (int amount = this.getStackSize(spellStats); amount > 0; amount -= size) {
            size = Math.min(amount, 64);
            ExtractedStack casterStack = this.extractItem(inventoryManager, i -> {
                if (i.m_41619_()) {
                    return false;
                }
                if (i.m_204117_(ItemTagProvider.TOSS_BLACKLIST)) {
                    return false;
                }
                if (context.getCaster() instanceof TileCaster) {
                    return true;
                }
                return shooter instanceof Player && !ItemStack.m_41728_((ItemStack)shooter.m_21205_(), (ItemStack)i);
            }, size, spellStats.isRandomized());
            consumer.accept(casterStack);
        }
    }

    public void summonStack(LivingEntity shooter, SpellContext context, SpellStats spellStats, Level world, BlockPos pos, InventoryManager inventoryManager) {
        this.processStacks(shooter, context, spellStats, inventoryManager, stack -> {
            world.m_7967_((Entity)new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, stack.stack.m_41777_()));
            stack.stack.m_41764_(0);
        });
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        BlockPos pos = rayTraceResult.m_82425_().m_121945_(rayTraceResult.m_82434_());
        InventoryManager manager = new InventoryManager(spellContext.getCaster());
        if (world.m_7702_(rayTraceResult.m_82425_()) == null) {
            this.summonStack(shooter, spellContext, spellStats, world, pos, manager);
            return;
        }
        BlockEntity tileEntity = world.m_7702_(rayTraceResult.m_82425_());
        IItemHandler targetInv = (IItemHandler)tileEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        if (targetInv == null) {
            return;
        }
        this.processStacks(shooter, spellContext, spellStats, manager, stack -> {
            stack.stack = ItemHandlerHelper.insertItemStacked((IItemHandler)targetInv, (ItemStack)stack.getStack(), (boolean)false);
            stack.returnOrDrop(world, pos);
        });
    }

    @Override
    @NotNull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.MANIPULATION);
    }

    @Override
    public int getDefaultManaCost() {
        return 10;
    }

    @Override
    public String getBookDescription() {
        return "Causes the caster to place an item from their inventory to a location. If this glyph is used on an inventory, the item will attempt to be inserted into it. Toss throws 64 items by default. Dampen will halve the amount each time. Amplify will double the amount each time. Randomize will select a random stack.";
    }

    @Override
    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentExtract.INSTANCE, AugmentRandomize.INSTANCE, AugmentDampen.INSTANCE, AugmentAmplify.INSTANCE);
    }
}

