/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zetaimplforge.event;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.zeta.Zeta;
import org.violetmoon.zeta.event.bus.IZetaLoadEvent;
import org.violetmoon.zeta.event.bus.IZetaPlayEvent;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.bus.ZetaEventBus;
import org.violetmoon.zetaimplforge.event.ForgeEventsRemapper;
import org.violetmoon.zetaimplforge.mod.ZetaModForge;

public class ForgeZetaEventBus<Z, F extends Event>
extends ZetaEventBus<Z> {
    private final Map<Key, Object> convertedHandlers = new Object2ObjectOpenHashMap();
    private final IEventBus forgeBus;
    private final Class<F> forgeEventRoot;
    private final ForgeEventsRemapper<Z, F> remapper;
    private static final ForgeEventsRemapper<IZetaLoadEvent, Event> DEFAULT_LOAD_EVENTS_REMAPPER = (ForgeEventsRemapper)Util.m_137469_(new ForgeEventsRemapper<IZetaLoadEvent, Event>(IZetaLoadEvent.class, Event.class), ZetaModForge.PROXY::addKnownZetaLoadEvents);
    private static final ForgeEventsRemapper<IZetaPlayEvent, Event> DEFAULT_PLAY_EVENTS_REMAPPER = (ForgeEventsRemapper)Util.m_137469_(new ForgeEventsRemapper<IZetaPlayEvent, Event>(IZetaPlayEvent.class, Event.class), ZetaModForge.PROXY::addKnownZetaPlayEvents);

    protected ForgeZetaEventBus(Class<? extends Annotation> subscriberAnnotation, Class<Z> eventRoot, @Nullable Logger logSpam, IEventBus forgeBus, Class<F> forgeEventRoot, Zeta ofZeta, ForgeEventsRemapper<Z, F> remapper) {
        super(subscriberAnnotation, eventRoot, logSpam, ofZeta);
        this.forgeBus = forgeBus;
        this.forgeEventRoot = forgeEventRoot;
        this.remapper = remapper;
    }

    public static ForgeZetaEventBus<IZetaLoadEvent, Event> ofLoadBus(@Nullable Logger logSpam, Zeta ofZeta) {
        return new ForgeZetaEventBus<IZetaLoadEvent, Event>(LoadEvent.class, IZetaLoadEvent.class, logSpam, FMLJavaModLoadingContext.get().getModEventBus(), Event.class, ofZeta, DEFAULT_LOAD_EVENTS_REMAPPER);
    }

    public static ForgeZetaEventBus<IZetaPlayEvent, Event> ofPlayBus(@Nullable Logger logSpam, Zeta ofZeta) {
        return new ForgeZetaEventBus<IZetaPlayEvent, Event>(PlayEvent.class, IZetaPlayEvent.class, logSpam, MinecraftForge.EVENT_BUS, Event.class, ofZeta, DEFAULT_PLAY_EVENTS_REMAPPER);
    }

    @Override
    protected void subscribeMethod(Method method, Object receiver, Class<?> owningClazz) {
        MethodHandle handle;
        if (method.getParameterCount() != 1) {
            throw this.arityERR(method);
        }
        Class<?> zetaEventClass = method.getParameterTypes()[0];
        if (!this.eventRoot.isAssignableFrom(zetaEventClass) && !this.forgeEventRoot.isAssignableFrom(zetaEventClass)) {
            throw this.typeERR(method);
        }
        try {
            handle = MethodHandles.publicLookup().unreflect(method);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (receiver != null) {
            handle = handle.bindTo(receiver);
        }
        Object convertedMethod = this.remapper.remapAndRegister(this.forgeBus, owningClazz, handle, zetaEventClass);
        this.convertedHandlers.put(new Key(method, receiver, owningClazz), convertedMethod);
    }

    @Override
    protected void unsubscribeMethod(Method m, Object receiver, Class<?> owningClazz) {
        Object handler = this.convertedHandlers.remove(new Key(m, receiver, owningClazz));
        if (handler != null) {
            this.forgeBus.unregister(handler);
        }
    }

    @Override
    public <T extends Z> T fire(@NotNull T event) {
        this.forgeBus.post(this.remapper.remapEvent(event, event.getClass()));
        return event;
    }

    @Override
    public <T extends Z> T fire(@NotNull T event, Class<? super T> firedAs) {
        this.forgeBus.post(this.remapper.remapEvent(event, firedAs));
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S extends Z, C extends Z> void registerWrapperWithGenerics(Class<C> baseZetaEventClass, Class<S> forgeZetaEventClass, Class<?> genericClass) {
        ForgeEventsRemapper<Z, F> forgeEventsRemapper = this.remapper;
        synchronized (forgeEventsRemapper) {
            this.remapper.registerWrapperWithGeneric(baseZetaEventClass, forgeZetaEventClass, genericClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ZF extends Z, ZB extends Z> void registerWrapper(Class<ZB> baseZetaEventClass, Class<ZF> forgeZetaEventClass) {
        ForgeEventsRemapper<Z, F> forgeEventsRemapper = this.remapper;
        synchronized (forgeEventsRemapper) {
            this.remapper.registerWrapper(baseZetaEventClass, forgeZetaEventClass, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ZF extends Z, ZB extends Z> void registerWrapperWithGenerics(Class<ZB> baseZetaEventClass, Class<ZF> forgeZetaEventClass, Function<? extends F, ZF> constructor, Class<?> genericClass) {
        ForgeEventsRemapper<Z, F> forgeEventsRemapper = this.remapper;
        synchronized (forgeEventsRemapper) {
            this.remapper.registerWrapperWithGeneric(baseZetaEventClass, forgeZetaEventClass, constructor, genericClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ZF extends Z, ZB extends Z> void registerWrapper(Class<ZB> baseZetaEventClass, Class<ZF> forgeZetaEventClass, @Nullable Function<? extends F, ZF> constructor) {
        ForgeEventsRemapper<Z, F> forgeEventsRemapper = this.remapper;
        synchronized (forgeEventsRemapper) {
            this.remapper.registerWrapper(baseZetaEventClass, forgeZetaEventClass, constructor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ZF extends Z, ZB extends Z, F2 extends F> void registerWrapper(Class<ZB> baseZetaEventClass, Class<F2> forgeEventClass, Function<F2, ZF> constructor, Function<ZF, ? extends F> unwrapper) {
        ForgeEventsRemapper<Z, F> forgeEventsRemapper = this.remapper;
        synchronized (forgeEventsRemapper) {
            this.remapper.registerWrapper(baseZetaEventClass, forgeEventClass, constructor, unwrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ZF extends Z, ZB extends Z, F2 extends F> void registerWrapperWithGenerics(Class<ZB> baseZetaEventClass, Class<F2> forgeEventClass, Function<F2, ZF> constructor, Function<ZF, ? extends F> unwrapper, Class<?> generic) {
        ForgeEventsRemapper<Z, F> forgeEventsRemapper = this.remapper;
        synchronized (forgeEventsRemapper) {
            this.remapper.registerWrapperWithGenerics(baseZetaEventClass, forgeEventClass, constructor, unwrapper, generic);
        }
    }

    private record Key(Method method, Object receiver, Class<?> owningClazz) {
    }
}

