/*
 * Decompiled with CFR 0.152.
 */
package com.diggydwarff.tobacconistmod;

import com.diggydwarff.tobacconistmod.TobacconistCreativeTab;
import com.diggydwarff.tobacconistmod.block.ModBlocks;
import com.diggydwarff.tobacconistmod.block.entity.ModBlockEntities;
import com.diggydwarff.tobacconistmod.effect.ModEffects;
import com.diggydwarff.tobacconistmod.items.ModItems;
import com.diggydwarff.tobacconistmod.items.custom.BottledMolassesFlavors;
import com.diggydwarff.tobacconistmod.items.custom.LooseTobacco;
import com.diggydwarff.tobacconistmod.recipes.ModRecipes;
import com.diggydwarff.tobacconistmod.screen.HookahScreen;
import com.diggydwarff.tobacconistmod.screen.ModMenuTypes;
import com.diggydwarff.tobacconistmod.villager.ModVillagers;
import com.mojang.logging.LogUtils;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.slf4j.Logger;

@Mod(value="tobacconistmod")
public class TobacconistMod {
    public static final String MODID = "tobacconistmod";
    private static final Logger LOGGER = LogUtils.getLogger();

    public TobacconistMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        TobacconistCreativeTab.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::register);
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModVillagers.register(modEventBus);
        ModRecipes.register(modEventBus);
        ModEffects.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModMenuTypes.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void register(RegisterEvent event) {
        event.register(ForgeRegistries.Keys.ITEMS, helper -> {
            for (LooseTobacco looseTobacco : LooseTobacco.values()) {
                helper.register(new ResourceLocation(MODID, looseTobacco.getName()), (Object)looseTobacco.getItem());
            }
            for (Enum enum_ : BottledMolassesFlavors.values()) {
                helper.register(new ResourceLocation(MODID, ((BottledMolassesFlavors)enum_).getName()), (Object)((BottledMolassesFlavors)enum_).getItem());
            }
        });
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42589_}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41909_}), (ItemStack)new ItemStack((ItemLike)BottledMolassesFlavors.BOTTLED_MOLASSES_PLAIN.getItem()));
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @Mod.EventBusSubscriber(modid="tobacconistmod", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.WILD_TOBACCO_CROP.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.VIRGINIA_TOBACCO_CROP.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.BURLEY_TOBACCO_CROP.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.ORIENTAL_TOBACCO_CROP.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.DOKHA_TOBACCO_CROP.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.SHADE_TOBACCO_CROP.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.HOOKAH.get()), (RenderType)RenderType.m_110466_());
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.HOOKAH_MENU.get()), HookahScreen::new);
        }
    }
}

