/*
 * Decompiled with CFR 0.152.
 */
package com.diggydwarff.tobacconistmod.block.entity;

import com.diggydwarff.tobacconistmod.block.entity.ModBlockEntities;
import com.diggydwarff.tobacconistmod.items.ModItems;
import com.diggydwarff.tobacconistmod.screen.HookahMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HookahEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            HookahEntity.this.m_6596_();
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> HookahEntity.this.progress;
                case 1 -> HookahEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    HookahEntity.this.progress = value;
                    break;
                }
                case 1: {
                    HookahEntity.this.maxProgress = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    public int progress = 0;
    private int maxProgress = 5000;

    public HookahEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.HOOKAH.get(), pos, state);
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Hookah");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new HookahMenu(id, inventory, this, this.data);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        nbt.m_128405_("hookah.progress", this.progress);
        super.m_183515_(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.progress = nbt.m_128451_("hookah.progress");
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, HookahEntity pEntity) {
        if (level.m_5776_()) {
            return;
        }
        if (HookahEntity.hasRecipe(pEntity)) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123777_, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), 1, 0.0, 0.0, 0.0, 0.0);
            ++pEntity.progress;
            ItemStack itemStack = pEntity.itemHandler.getStackInSlot(1);
            itemStack.m_41721_(itemStack.m_41773_() + 1);
            if (itemStack.m_41773_() >= itemStack.m_41776_()) {
                pEntity.itemHandler.extractItem(1, 1, false);
            }
            HookahEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
            if (pEntity.progress >= pEntity.maxProgress) {
                HookahEntity.craftItem(pEntity);
            }
        } else {
            pEntity.resetProgress();
            HookahEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private static void craftItem(HookahEntity pEntity) {
        if (HookahEntity.hasRecipe(pEntity)) {
            pEntity.itemHandler.extractItem(1, 1, false);
            pEntity.itemHandler.setStackInSlot(2, new ItemStack((ItemLike)ModItems.SHISHA_TOBACCO.get(), pEntity.itemHandler.getStackInSlot(2).m_41613_() + 1));
            pEntity.resetProgress();
        }
    }

    private static boolean hasRecipe(HookahEntity entity) {
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, entity.itemHandler.getStackInSlot(i));
        }
        boolean hasShishaInSlot = entity.itemHandler.getStackInSlot(1).m_41720_() == ModItems.SHISHA_TOBACCO.get();
        boolean hasCoalInSlot = entity.itemHandler.getStackInSlot(0).m_41720_() == Items.f_42413_;
        boolean hasWaterInSlot = entity.itemHandler.getStackInSlot(2).m_41720_() == Items.f_42589_;
        return hasShishaInSlot && hasCoalInSlot && hasWaterInSlot;
    }

    private static boolean canInsertItemIntoOutputSlot(SimpleContainer inventory, ItemStack stack) {
        return inventory.m_8020_(2).m_41720_() == stack.m_41720_() || inventory.m_8020_(2).m_41619_();
    }

    private static boolean canInsertAmountIntoOutputSlot(SimpleContainer inventory) {
        return inventory.m_8020_(2).m_41741_() > inventory.m_8020_(2).m_41613_();
    }
}

