/*
 * Decompiled with CFR 0.152.
 */
package com.diggydwarff.tobacconistmod.recipes;

import com.diggydwarff.tobacconistmod.items.ModItems;
import com.diggydwarff.tobacconistmod.items.custom.LooseTobaccoItem;
import com.diggydwarff.tobacconistmod.items.custom.RollingPaperItem;
import com.diggydwarff.tobacconistmod.recipes.ModRecipes;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CigaretteRecipe
extends CustomRecipe {
    private final ResourceLocation id;
    private final ItemStack output;
    private final NonNullList<Ingredient> recipeItems;

    public CigaretteRecipe(ResourceLocation id, ItemStack output, NonNullList<Ingredient> recipeItems) {
        super(id, CraftingBookCategory.MISC);
        this.id = id;
        this.output = output;
        this.recipeItems = recipeItems;
    }

    public boolean matches(CraftingContainer craftingContainer, Level level) {
        ItemStack itemstack = ItemStack.f_41583_;
        ItemStack tobaccoStack = ItemStack.f_41583_;
        ItemStack paperStack = ItemStack.f_41583_;
        for (int i = 0; i < craftingContainer.m_6643_(); ++i) {
            itemstack = craftingContainer.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            if (itemstack.m_41720_() instanceof LooseTobaccoItem) {
                tobaccoStack = itemstack;
                continue;
            }
            if (itemstack.m_41720_() instanceof RollingPaperItem) {
                paperStack = itemstack;
                continue;
            }
            return false;
        }
        return !tobaccoStack.m_41619_() && !paperStack.m_41619_();
    }

    public ItemStack assemble(CraftingContainer craftingContainer, RegistryAccess pRegistryAccess) {
        ItemStack itemstack = ItemStack.f_41583_;
        ItemStack tobaccoStack = ItemStack.f_41583_;
        for (int i = 0; i < craftingContainer.m_6643_(); ++i) {
            itemstack = craftingContainer.m_8020_(i);
            if (itemstack.m_41619_() || !(itemstack.m_41720_() instanceof LooseTobaccoItem)) continue;
            tobaccoStack = itemstack;
        }
        Item newItem = (Item)ModItems.CIGARETTE.get();
        ItemStack returnStack = new ItemStack((ItemLike)newItem, 1);
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.m_128359_("tobacco", tobaccoStack.m_41611_().getString());
        returnStack.m_41751_(compoundtag);
        return returnStack;
    }

    public boolean m_8004_(int p_44298_, int p_44299_) {
        return p_44298_ * p_44299_ >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.CIGARETTE_RECIPE_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<CigaretteRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("tobacconistmod", "crafting_special_cigarette");

        public CigaretteRecipe fromJson(ResourceLocation id, JsonObject json) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122780_((int)1, (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            return new CigaretteRecipe(id, output, (NonNullList<Ingredient>)inputs);
        }

        public CigaretteRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            NonNullList inputs = NonNullList.m_122780_((int)buf.readInt(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            ItemStack output = buf.m_130267_();
            return new CigaretteRecipe(id, output, (NonNullList<Ingredient>)inputs);
        }

        public void toNetwork(FriendlyByteBuf buf, CigaretteRecipe recipe) {
            buf.writeInt(recipe.m_7527_().size());
            for (Ingredient ing : recipe.m_7527_()) {
                ing.m_43923_(buf);
            }
            buf.writeItemStack(recipe.m_8043_(null), false);
        }
    }

    public static class Type
    implements RecipeType<CigaretteRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "crafting_special_cigarette";

        private Type() {
        }
    }
}

