/*
 * Decompiled with CFR 0.152.
 */
package fonnymunkey.simplehats.client.hat;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fonnymunkey.simplehats.common.init.ModConfig;
import fonnymunkey.simplehats.common.item.HatItem;
import fonnymunkey.simplehats.util.HatEntry;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class HatLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    public HatLayer(RenderLayerParent<T, M> renderer) {
        super(renderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float age, float netHeadYaw, float headPitch) {
        if (livingEntity == Minecraft.m_91087_().f_91075_ && Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON && ((Boolean)ModConfig.CLIENT.forceFirstPersonNoRender.get()).booleanValue()) {
            return;
        }
        CuriosApi.getCuriosInventory(livingEntity).ifPresent(handler -> handler.getCurios().forEach((id, stacksHandler) -> {
            if (stacksHandler.isVisible() && "head".equals(stacksHandler.getIdentifier())) {
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                IDynamicStackHandler cosmeticStacksHandler = stacksHandler.getCosmeticStacks();
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    boolean renderable;
                    ItemStack stack = cosmeticStacksHandler.getStackInSlot(i);
                    NonNullList renderStates = stacksHandler.getRenders();
                    boolean bl = renderable = renderStates.size() > i && (Boolean)renderStates.get(i) != false;
                    if (stack.m_41619_() && renderable) {
                        stack = stackHandler.getStackInSlot(i);
                    }
                    if (stack.m_41619_() || !(stack.m_41720_() instanceof HatItem)) continue;
                    this.render(stack, poseStack, buffer, packedLight, livingEntity, limbSwing, limbSwingAmount, partialTicks, age, netHeadYaw, headPitch);
                }
            }
        }));
    }

    private void render(ItemStack itemStack, PoseStack poseStack, MultiBufferSource buffer, int packedLight, T livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float age, float netHeadYaw, float headPitch) {
        HatEntry.HatParticleSettings particleSettings;
        if (!livingEntity.m_20145_()) {
            boolean flag;
            poseStack.m_85836_();
            poseStack.m_85841_(1.01f, 1.01f, 1.01f);
            poseStack.m_85837_(0.0, 0.0 - (Double)ModConfig.CLIENT.hatYOffset.get(), 0.0);
            boolean bl = flag = livingEntity instanceof Villager || livingEntity instanceof ZombieVillager;
            if (livingEntity.m_6162_() && !(livingEntity instanceof Villager)) {
                poseStack.m_252880_(0.0f, 0.03125f, 0.0f);
                poseStack.m_85841_(0.7f, 0.7f, 0.7f);
                poseStack.m_252880_(0.0f, 1.0f, 0.0f);
            }
            ((HeadedModel)this.m_117386_()).m_5585_().m_104299_(poseStack);
            HatLayer.translateToHead(poseStack, flag);
            Minecraft.m_91087_().m_91290_().m_234586_().m_269530_(livingEntity, itemStack, ItemDisplayContext.HEAD, false, poseStack, buffer, packedLight);
            poseStack.m_85849_();
        }
        if (livingEntity instanceof Player && (particleSettings = ((HatItem)itemStack.m_41720_()).getHatEntry().getHatParticleSettings()).getUseParticles() && !Minecraft.m_91087_().m_91104_()) {
            float f = livingEntity.m_217043_().m_188501_();
            float f2 = livingEntity.m_20145_() ? particleSettings.getParticleFrequency() / 2.0f : particleSettings.getParticleFrequency();
            if (f < f2) {
                double d0 = livingEntity.m_217043_().m_188583_() * 0.02;
                double d1 = livingEntity.m_217043_().m_188583_() * 0.02;
                double d2 = livingEntity.m_217043_().m_188583_() * 0.02;
                double y = switch (particleSettings.getParticleMovement()) {
                    default -> throw new IncompatibleClassChangeError();
                    case HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD -> livingEntity.m_20186_() + 1.75;
                    case HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_FEET -> livingEntity.m_20186_() + 0.25;
                    case HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_FULL -> livingEntity.m_20187_();
                };
                livingEntity.m_9236_().m_7106_((ParticleOptions)particleSettings.getParticleType(), livingEntity.m_20208_(0.5), y, livingEntity.m_20262_(0.5), d0, d1, d2);
            }
        }
    }

    private static void translateToHead(PoseStack pPoseStack, boolean pIsVillager) {
        pPoseStack.m_252880_(0.0f, -0.25f, 0.0f);
        pPoseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        pPoseStack.m_85841_(0.625f, -0.625f, -0.625f);
        if (pIsVillager) {
            pPoseStack.m_252880_(0.0f, 0.1875f, 0.0f);
        }
    }
}

