/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.render;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.api.common.data.OtherworldBlockTier;
import com.klikli_dev.occultism.common.block.otherworld.IOtherworldBlock;
import com.klikli_dev.occultism.registry.OccultismEffects;
import com.klikli_dev.occultism.util.CuriosUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ThirdEyeEffectRenderer {
    public static final int MAX_THIRD_EYE_DISTANCE = 10;
    public static final ResourceLocation THIRD_EYE_SHADER = new ResourceLocation("occultism", "shaders/post/third_eye.json");
    public static final ResourceLocation THIRD_EYE_TEXTURE = new ResourceLocation("occultism", "textures/overlay/third_eye.png");
    public boolean thirdEyeActiveLastTick = false;
    public boolean gogglesActiveLastTick = false;
    public Set<BlockPos> uncoveredBlocks = new HashSet<BlockPos>();

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player.m_9236_().f_46443_ && event.player == Minecraft.m_91087_().f_91074_) {
            this.onThirdEyeTick(event);
            this.onGogglesTick(event);
        }
    }

    public void renderOverlay(PoseStack pose) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)THIRD_EYE_TEXTURE);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.clearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Window window = Minecraft.m_91087_().m_91268_();
        pose.m_85836_();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_5483_(0.0, (double)window.m_85446_(), -90.0).m_7421_(0.0f, 1.0f).m_5752_();
        buffer.m_5483_((double)window.m_85445_(), (double)window.m_85446_(), -90.0).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_5483_((double)window.m_85445_(), 0.0, -90.0).m_7421_(1.0f, 0.0f).m_5752_();
        buffer.m_5483_(0.0, 0.0, -90.0).m_7421_(0.0f, 0.0f).m_5752_();
        tessellator.m_85914_();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        pose.m_85849_();
        RenderSystem.clearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    public void resetUncoveredBlocks(Level level, boolean clear) {
        for (BlockPos pos : this.uncoveredBlocks) {
            BlockState state = level.m_8055_(pos);
            if (!(state.m_60734_() instanceof IOtherworldBlock)) continue;
            level.m_7731_(pos, (BlockState)state.m_61124_(IOtherworldBlock.UNCOVERED, (Comparable)Boolean.valueOf(false)), 1);
        }
        if (clear) {
            this.uncoveredBlocks.clear();
        }
    }

    public void uncoverBlocks(Player player, Level level, OtherworldBlockTier tier) {
        BlockPos origin = player.m_20183_();
        BlockPos.m_121940_((BlockPos)origin.m_7918_(-10, -10, -10), (BlockPos)origin.m_7918_(10, 10, 10)).forEach(pos -> {
            IOtherworldBlock block;
            BlockState state = level.m_8055_(pos);
            Block patt5696$temp = state.m_60734_();
            if (patt5696$temp instanceof IOtherworldBlock && (block = (IOtherworldBlock)patt5696$temp).getTier().getLevel() <= tier.getLevel()) {
                if (!((Boolean)state.m_61143_(IOtherworldBlock.UNCOVERED)).booleanValue()) {
                    level.m_7731_(pos, (BlockState)state.m_61124_(IOtherworldBlock.UNCOVERED, (Comparable)Boolean.valueOf(true)), 1);
                }
                this.uncoveredBlocks.add(pos.m_7949_());
            }
        });
    }

    public void onThirdEyeTick(TickEvent.PlayerTickEvent event) {
        int duration;
        boolean hasGoggles = CuriosUtil.hasGoggles(event.player);
        if (hasGoggles) {
            return;
        }
        MobEffectInstance effect = event.player.m_21124_((MobEffect)OccultismEffects.THIRD_EYE.get());
        int n = duration = effect == null ? 0 : effect.m_19557_();
        if (duration > 1) {
            if (!this.thirdEyeActiveLastTick) {
                this.thirdEyeActiveLastTick = true;
                if (!((Boolean)Occultism.CLIENT_CONFIG.visuals.disableDemonsDreamShaders.get()).booleanValue()) {
                    Minecraft.m_91087_().m_6937_(() -> Minecraft.m_91087_().f_91063_.m_109128_(THIRD_EYE_SHADER));
                }
            }
            this.uncoverBlocks(event.player, event.player.m_9236_(), OtherworldBlockTier.ONE);
        } else {
            this.resetUncoveredBlocks(event.player.m_9236_(), duration == 0);
            if (this.thirdEyeActiveLastTick) {
                this.thirdEyeActiveLastTick = false;
                if (!((Boolean)Occultism.CLIENT_CONFIG.visuals.disableDemonsDreamShaders.get()).booleanValue()) {
                    Minecraft.m_91087_().m_6937_(() -> Minecraft.m_91087_().f_91063_.m_109086_());
                }
            }
        }
    }

    public void onGogglesTick(TickEvent.PlayerTickEvent event) {
        boolean hasGoggles = CuriosUtil.hasGoggles(event.player);
        if (hasGoggles) {
            if (!this.gogglesActiveLastTick) {
                this.gogglesActiveLastTick = true;
            }
            this.uncoverBlocks(event.player, event.player.m_9236_(), OtherworldBlockTier.TWO);
        } else if (this.gogglesActiveLastTick) {
            this.gogglesActiveLastTick = false;
            this.resetUncoveredBlocks(event.player.m_9236_(), true);
            if (this.thirdEyeActiveLastTick) {
                this.uncoverBlocks(event.player, event.player.m_9236_(), OtherworldBlockTier.ONE);
            }
        }
    }
}

