/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.item.spirit.calling;

import com.klikli_dev.occultism.api.common.blockentity.IStorageController;
import com.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import com.klikli_dev.occultism.common.entity.job.ManageMachineJob;
import com.klikli_dev.occultism.common.entity.job.SpiritJob;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.common.item.spirit.calling.ItemMode;
import com.klikli_dev.occultism.util.EntityUtil;
import com.klikli_dev.occultism.util.ItemNBTUtil;
import com.klikli_dev.occultism.util.TextUtil;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SetStorageLocationMode
extends ItemMode {
    public SetStorageLocationMode() {
        super("set_storage_controller");
    }

    public boolean setSpiritStorageController(Player player, Level world, BlockPos pos, ItemStack stack, Direction face) {
        UUID boundSpiritId = ItemNBTUtil.getSpiritEntityUUID(stack);
        if (boundSpiritId != null) {
            Optional<SpiritEntity> boundSpirit = EntityUtil.getEntityByUuiDGlobal(world.m_7654_(), boundSpiritId).map(e -> (SpiritEntity)e);
            if (boundSpirit.isPresent() && boundSpirit.get().getJob().isPresent()) {
                SpiritJob spiritJob = boundSpirit.get().getJob().get();
                if (spiritJob instanceof ManageMachineJob) {
                    ManageMachineJob job = (ManageMachineJob)spiritJob;
                    job.setStorageControllerPosition(new GlobalBlockPos(pos, world));
                    ItemNBTUtil.updateItemNBTFromEntity(stack, boundSpirit.get());
                    String blockName = world.m_8055_(pos).m_60734_().m_7705_();
                    player.m_5661_((Component)Component.m_237110_((String)"item.occultism.book_of_calling.message_set_storage_controller", (Object[])new Object[]{TextUtil.formatDemonName(boundSpirit.get().m_7755_().getString()), Component.m_237115_((String)blockName)}), true);
                    return true;
                }
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"item.occultism.book_of_calling.message_spirit_not_found"), true);
            }
        }
        return false;
    }

    @Override
    public boolean handle(BlockEntity blockEntity, Player player, Level world, BlockPos pos, ItemStack stack, Direction face) {
        if (blockEntity instanceof IStorageController) {
            return this.setSpiritStorageController(player, world, pos, stack, face);
        }
        return true;
    }
}

