/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.integration.jei.recipes;

import com.klikli_dev.modonomicon.api.ModonomiconAPI;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.occultism.crafting.recipe.RitualRecipe;
import com.klikli_dev.occultism.integration.jei.JeiRecipeTypes;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.occultism.util.GuiGraphicsExt;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class RitualRecipeCategory
implements IRecipeCategory<RitualRecipe> {
    private final IDrawable background;
    private final IDrawable arrow;
    private final Component localizedName;
    private final String pentacle;
    private final ItemStack goldenSacrificialBowl = new ItemStack((ItemLike)OccultismBlocks.GOLDEN_SACRIFICIAL_BOWL.get());
    private final ItemStack sacrificialBowl = new ItemStack((ItemLike)OccultismBlocks.SACRIFICIAL_BOWL.get());
    private final int iconWidth = 16;
    private final int ritualCenterX;
    private final int ritualCenterY;
    private int recipeOutputOffsetX = 50;

    public RitualRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(168, 120);
        this.ritualCenterX = this.background.getWidth() / 2 - this.iconWidth / 2 - 30;
        this.ritualCenterY = this.background.getHeight() / 2 - this.iconWidth / 2 + 20;
        this.localizedName = Component.m_237115_((String)"occultism.jei.ritual");
        this.pentacle = I18n.m_118938_((String)"occultism.jei.pentacle", (Object[])new Object[0]);
        this.goldenSacrificialBowl.m_41784_().m_128379_("RenderFull", true);
        this.sacrificialBowl.m_41784_().m_128379_("RenderFull", true);
        this.arrow = guiHelper.createDrawable(new ResourceLocation("occultism", "textures/gui/jei/arrow.png"), 0, 0, 64, 46);
    }

    protected int getStringCenteredMaxX(Font font, Component text, int x, int y) {
        int width = font.m_92852_((FormattedText)text);
        int actualX = (int)((float)x - (float)width / 2.0f);
        return actualX + width;
    }

    protected void drawStringCentered(GuiGraphics guiGraphics, Font font, Component text, int x, int y) {
        GuiGraphicsExt.drawString(guiGraphics, font, text, (float)x - (float)font.m_92852_((FormattedText)text) / 2.0f, (float)y, 0, false);
    }

    protected void drawStringCentered(GuiGraphics guiGraphics, Font font, FormattedCharSequence text, int x, int y) {
        GuiGraphicsExt.drawString(guiGraphics, font, text, (float)x - (float)font.m_92724_(text) / 2.0f, (float)y, 0, false);
    }

    public RecipeType<RitualRecipe> getRecipeType() {
        return JeiRecipeTypes.RITUAL;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RitualRecipe recipe, IFocusGroup focuses) {
        this.recipeOutputOffsetX = 75;
        builder.addSlot(RecipeIngredientRole.INPUT, this.ritualCenterX, this.ritualCenterY - 5).addIngredients(recipe.getActivationItem());
        builder.addSlot(RecipeIngredientRole.CATALYST, this.ritualCenterX, this.ritualCenterY).addItemStack(this.goldenSacrificialBowl);
        int sacrificialCircleRadius = 30;
        int sacricialBowlPaddingVertical = 20;
        int sacricialBowlPaddingHorizontal = 15;
        List sacrificialBowlPosition = Stream.of(new Vec3i(this.ritualCenterX, this.ritualCenterY - sacrificialCircleRadius, 0), new Vec3i(this.ritualCenterX + sacrificialCircleRadius, this.ritualCenterY, 0), new Vec3i(this.ritualCenterX, this.ritualCenterY + sacrificialCircleRadius, 0), new Vec3i(this.ritualCenterX - sacrificialCircleRadius, this.ritualCenterY, 0), new Vec3i(this.ritualCenterX + sacricialBowlPaddingHorizontal, this.ritualCenterY - sacrificialCircleRadius, 0), new Vec3i(this.ritualCenterX + sacrificialCircleRadius, this.ritualCenterY - sacricialBowlPaddingVertical, 0), new Vec3i(this.ritualCenterX - sacricialBowlPaddingHorizontal, this.ritualCenterY + sacrificialCircleRadius, 0), new Vec3i(this.ritualCenterX - sacrificialCircleRadius, this.ritualCenterY + sacricialBowlPaddingVertical, 0), new Vec3i(this.ritualCenterX - sacricialBowlPaddingHorizontal, this.ritualCenterY - sacrificialCircleRadius, 0), new Vec3i(this.ritualCenterX + sacrificialCircleRadius, this.ritualCenterY + sacricialBowlPaddingVertical, 0), new Vec3i(this.ritualCenterX + sacricialBowlPaddingHorizontal, this.ritualCenterY + sacrificialCircleRadius, 0), new Vec3i(this.ritualCenterX - sacrificialCircleRadius, this.ritualCenterY - sacricialBowlPaddingVertical, 0)).collect(Collectors.toList());
        for (int i = 0; i < recipe.m_7527_().size(); ++i) {
            Vec3i pos = (Vec3i)sacrificialBowlPosition.get(i);
            builder.addSlot(RecipeIngredientRole.INPUT, pos.m_123341_(), pos.m_123342_() - 5).addIngredients((Ingredient)recipe.m_7527_().get(i));
            builder.addSlot(RecipeIngredientRole.RENDER_ONLY, pos.m_123341_(), pos.m_123342_()).addItemStack(this.sacrificialBowl);
        }
        RegistryAccess access = Minecraft.m_91087_().f_91073_.m_9598_();
        if (recipe.m_8043_(access).m_41720_() != OccultismItems.JEI_DUMMY_NONE.get()) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, this.ritualCenterX + this.recipeOutputOffsetX, this.ritualCenterY - 5).addItemStack(recipe.m_8043_(access));
        } else {
            builder.addSlot(RecipeIngredientRole.OUTPUT, this.ritualCenterX + this.recipeOutputOffsetX, this.ritualCenterY - 5).addItemStack(recipe.getRitualDummy());
        }
        builder.addSlot(RecipeIngredientRole.CATALYST, this.ritualCenterX + this.recipeOutputOffsetX, this.ritualCenterY).addItemStack(this.goldenSacrificialBowl);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 0, 0).addItemStack(recipe.getRitualDummy());
        if (recipe.requiresItemUse()) {
            int infotextY = 0;
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            int lineHeight = 9;
            Multiblock pentacle = ModonomiconAPI.get().getMultiblock(recipe.getPentacleId());
            if (pentacle != null) {
                List pentacleName = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)Component.m_237115_((String)Util.m_137492_((String)"multiblock", (ResourceLocation)pentacle.getId())), 150);
                for (FormattedCharSequence line : pentacleName) {
                    infotextY += lineHeight;
                }
            }
            if (recipe.requiresSacrifice()) {
                infotextY += lineHeight;
            }
            int itemToUseY = infotextY - 5;
            int infoTextX = 94;
            int itemToUseX = this.getStringCenteredMaxX(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"jei.occultism.item_to_use"), infoTextX, infotextY);
            builder.addSlot(RecipeIngredientRole.CATALYST, itemToUseX, itemToUseY).addIngredients(recipe.getItemToUse());
        }
    }

    public void draw(RitualRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        RenderSystem.enableBlend();
        this.arrow.draw(guiGraphics, this.ritualCenterX + this.recipeOutputOffsetX - 20, this.ritualCenterY);
        RenderSystem.disableBlend();
        int infotextY = 0;
        int infoTextX = 94;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        int lineHeight = 9;
        Multiblock pentacle = ModonomiconAPI.get().getMultiblock(recipe.getPentacleId());
        if (pentacle != null) {
            List pentacleName = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)Component.m_237115_((String)Util.m_137492_((String)"multiblock", (ResourceLocation)pentacle.getId())), 150);
            for (FormattedCharSequence line : pentacleName) {
                this.drawStringCentered(guiGraphics, Minecraft.m_91087_().f_91062_, line, infoTextX, infotextY);
                infotextY += lineHeight;
            }
        } else {
            this.drawStringCentered(guiGraphics, Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"jei.occultism.error.pentacle_not_loaded"), infoTextX, 0);
        }
        if (recipe.requiresSacrifice()) {
            this.drawStringCentered(guiGraphics, Minecraft.m_91087_().f_91062_, (Component)Component.m_237110_((String)"jei.occultism.sacrifice", (Object[])new Object[]{Component.m_237115_((String)recipe.getEntityToSacrificeDisplayName())}), infoTextX, infotextY);
            infotextY += lineHeight;
        }
        if (recipe.requiresItemUse()) {
            this.drawStringCentered(guiGraphics, Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"jei.occultism.item_to_use"), infoTextX, infotextY);
            infotextY += lineHeight;
        }
        if (recipe.getEntityToSummon() != null) {
            this.drawStringCentered(guiGraphics, Minecraft.m_91087_().f_91062_, (Component)Component.m_237110_((String)"jei.occultism.summon", (Object[])new Object[]{Component.m_237115_((String)recipe.getEntityToSummon().m_20675_())}), infoTextX, infotextY);
            infotextY += lineHeight;
        }
        if (recipe.getSpiritJobType() != null) {
            this.drawStringCentered(guiGraphics, Minecraft.m_91087_().f_91062_, (Component)Component.m_237110_((String)"jei.occultism.job", (Object[])new Object[]{Component.m_237115_((String)("job." + recipe.getSpiritJobType().toString().replace(":", ".")))}), infoTextX, infotextY);
        }
    }
}

