/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.client;

import codechicken.lib.render.block.ICCBlockRenderer;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mrtjp.projectred.expansion.MovementManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public class MovingBlockSuppressorRenderer
implements ICCBlockRenderer {
    public static final MovingBlockSuppressorRenderer INSTANCE = new MovingBlockSuppressorRenderer();
    public static boolean allowMovingRenderOnRenderThread = false;
    private static boolean isRendering = false;

    private MovingBlockSuppressorRenderer() {
    }

    public boolean canHandleBlock(BlockAndTintGetter world, BlockPos pos, BlockState blockState, @Nullable RenderType renderType) {
        if (isRendering) {
            return false;
        }
        MovementManager manager = MovementManager.getClientInstanceNullable();
        if (manager == null || manager.hasNoMovingStructures()) {
            return false;
        }
        boolean isMoving = MovingBlockSuppressorRenderer.isMoving(manager, pos);
        if (isMoving) {
            return !RenderSystem.isOnRenderThread() || !allowMovingRenderOnRenderThread;
        }
        return MovingBlockSuppressorRenderer.isAdjacentToMoving(manager, pos);
    }

    public void renderBlock(BlockState state, BlockPos pos, BlockAndTintGetter world, PoseStack mStack, VertexConsumer builder, RandomSource random, ModelData data, @Nullable RenderType renderType) {
        MovementManager manager = MovementManager.getClientInstanceNullable();
        if (manager != null && MovingBlockSuppressorRenderer.isMoving(manager, pos)) {
            return;
        }
        isRendering = true;
        Minecraft.m_91087_().m_91289_().renderBatched(state, pos, world, mStack, builder, false, random, data, renderType);
        isRendering = false;
    }

    private static boolean isMoving(MovementManager manager, BlockPos pos) {
        return manager.getMovementInfo(pos).isMoving();
    }

    private static boolean isAdjacentToMoving(MovementManager manager, BlockPos pos) {
        for (int s = 0; s < 6; ++s) {
            if (!MovingBlockSuppressorRenderer.isMoving(manager, pos.m_121945_(Direction.values()[s]))) continue;
            return true;
        }
        return false;
    }
}

