/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.client;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.buffer.TransformingVertexConsumer;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.api.part.render.PartRenderer;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nullable;
import mrtjp.projectred.expansion.client.TubeModelRenderer;
import mrtjp.projectred.expansion.part.BaseTubePart;
import mrtjp.projectred.expansion.part.PneumaticTubePayload;
import mrtjp.projectred.expansion.pneumatics.PneumaticTransportContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.BlockAndTintGetter;

public class TubePartRenderer
implements PartRenderer<BaseTubePart> {
    public static final TubePartRenderer INSTANCE = new TubePartRenderer();
    private static final Vector3[] SIDE_OFFSETS = new Vector3[]{new Vector3(0.5, 0.0, 0.5), new Vector3(0.5, 1.0, 0.5), new Vector3(0.5, 0.5, 0.0), new Vector3(0.5, 0.5, 1.0), new Vector3(0.0, 0.5, 0.5), new Vector3(1.0, 0.5, 0.5)};

    public void renderStatic(BaseTubePart part, @Nullable RenderType layer, CCRenderState ccrs) {
        if (layer == null || layer == RenderType.m_110463_() && part.useStaticRenderer()) {
            ccrs.setBrightness((BlockAndTintGetter)part.level(), part.pos());
            TubeModelRenderer.render(ccrs, part);
        }
    }

    public void renderDynamic(BaseTubePart part, PoseStack mStack, MultiBufferSource buffers, int packedLight, int packedOverlay, float partialTicks) {
        if (!part.useStaticRenderer()) {
            CCRenderState ccrs = CCRenderState.instance();
            ccrs.reset();
            ccrs.brightness = packedLight;
            ccrs.overlay = packedOverlay;
            ccrs.bind((VertexConsumer)new TransformingVertexConsumer(buffers.m_6299_(RenderType.m_110451_()), mStack), DefaultVertexFormat.f_85811_);
            TubeModelRenderer.render(ccrs, part);
        }
        this.renderPayloadTransport(part, mStack, buffers, packedLight, packedOverlay, partialTicks);
    }

    private void renderPayloadTransport(BaseTubePart part, PoseStack mStack, MultiBufferSource buffers, int packedLight, int packedOverlay, float partialTicks) {
        if (!(part instanceof PneumaticTransportContainer)) {
            return;
        }
        PneumaticTransportContainer ptc = (PneumaticTransportContainer)((Object)part);
        for (PneumaticTubePayload p : ptc.getPneumaticTransport().getPayloads()) {
            boolean isHalfWay = p.getProgress() >= 127;
            float pf = (float)p.getProgress() / 255.0f;
            float sf = (float)p.getSpeed() / 255.0f;
            float progress = pf + sf * partialTicks;
            int d = isHalfWay && p.getOutputSide() != -1 ? p.getOutputSide() : p.getInputSide() ^ 1;
            int dx = Direction.values()[d].m_122429_();
            int dy = Direction.values()[d].m_122430_();
            int dz = Direction.values()[d].m_122431_();
            Vector3 pos = SIDE_OFFSETS[d ^ 1].copy();
            Vector3 dir = new Vector3((double)dx, (double)dy, (double)dz);
            pos.add(dir.multiply((double)progress));
            mStack.m_85836_();
            mStack.m_85837_(pos.x, pos.y, pos.z);
            mStack.m_85841_(0.5f, 0.5f, 0.5f);
            ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
            BakedModel model = itemRenderer.m_174264_(p.getItemStack(), part.level(), null, 0);
            itemRenderer.m_115143_(p.getItemStack(), ItemDisplayContext.FIXED, false, mStack, buffers, packedLight, packedOverlay, model);
            mStack.m_85849_();
        }
    }
}

