/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.graphs;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Vector3;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import mrtjp.projectred.expansion.graphs.GraphLink;
import mrtjp.projectred.expansion.graphs.GraphLinkSegment;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;

public class ClientSideLinkCache {
    public final List<ClientLink> links = new LinkedList<ClientLink>();
    private boolean isActive = false;
    @Nullable
    private Consumer<List<ClientLink>> removedLinksCallback = null;
    @Nullable
    private Consumer<List<ClientLink>> addedLinksCallback = null;

    public boolean isActive() {
        return this.isActive;
    }

    public void setRemovedCallback(Consumer<List<ClientLink>> removedLinksCallback) {
        this.removedLinksCallback = removedLinksCallback;
    }

    public void setAddedCallback(Consumer<List<ClientLink>> addedLinksCallback) {
        this.addedLinksCallback = addedLinksCallback;
    }

    public void setLinks(List<GraphLink> links) {
        this.links.clear();
        for (GraphLink link : links) {
            this.links.add(new ClientLink(link.weight(), link.segments()));
        }
    }

    public void writeDesc(MCDataOutput packet) {
        packet.writeVarInt(this.links.size());
        for (ClientLink link : this.links) {
            link.writeDesc(packet);
        }
        packet.writeBoolean(this.isActive);
    }

    public void readDesc(MCDataInput packet) {
        this.links.clear();
        int size = packet.readVarInt();
        for (int i = 0; i < size; ++i) {
            this.links.add(ClientLink.readDesc(packet));
        }
        this.isActive = packet.readBoolean();
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    public void writeStateUpdate(MCDataOutput packet) {
        packet.writeBoolean(this.isActive);
    }

    public void writeLinkUpdate(MCDataOutput packet) {
        this.writeDesc(packet);
    }

    public void readStateUpdate(MCDataInput packet) {
        this.isActive = packet.readBoolean();
    }

    public void readLinkUpdate(MCDataInput packet) {
        LinkedList<ClientLink> oldList = new LinkedList<ClientLink>(this.links);
        this.readDesc(packet);
        LinkedList<ClientLink> removed = new LinkedList<ClientLink>();
        LinkedList<ClientLink> added = new LinkedList<ClientLink>();
        for (ClientLink link : oldList) {
            if (this.links.contains(link)) continue;
            removed.add(link);
        }
        for (ClientLink link : this.links) {
            if (oldList.contains(link)) continue;
            added.add(link);
        }
        if (this.removedLinksCallback != null) {
            this.removedLinksCallback.accept(removed);
        }
        if (this.addedLinksCallback != null) {
            this.addedLinksCallback.accept(added);
        }
    }

    public static class ClientLink {
        public final int weight;
        public final List<GraphLinkSegment> segments;
        private final Function<BlockPos, LinkedList<Vector3>> pointListCache = Util.m_143827_(this::buildPointList);

        public ClientLink(int weight, List<GraphLinkSegment> segments) {
            this.weight = weight;
            this.segments = segments;
        }

        public void writeDesc(MCDataOutput packet) {
            packet.writeVarInt(this.weight);
            packet.writeVarInt(this.segments.size());
            for (GraphLinkSegment segment : this.segments) {
                packet.writeByte(segment.dir());
                packet.writeVarInt(segment.length());
            }
        }

        public static ClientLink readDesc(MCDataInput packet) {
            int weight = packet.readVarInt();
            int segmentSize = packet.readVarInt();
            LinkedList<GraphLinkSegment> segments = new LinkedList<GraphLinkSegment>();
            for (int j = 0; j < segmentSize; ++j) {
                short dir = packet.readUByte();
                int length = packet.readVarInt();
                segments.add(new GraphLinkSegment(dir, length));
            }
            return new ClientLink(weight, segments);
        }

        public LinkedList<Vector3> getPointListFor(BlockPos pos) {
            return this.pointListCache.apply(pos);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClientLink that = (ClientLink)o;
            return this.weight == that.weight && Objects.equals(this.segments, that.segments);
        }

        public int hashCode() {
            return Objects.hash(this.weight, this.segments);
        }

        private LinkedList<Vector3> buildPointList(BlockPos from) {
            LinkedList<Vector3> points = new LinkedList<Vector3>();
            points.add(new Vector3((double)from.m_123341_() + 0.5, (double)from.m_123342_() + 0.5, (double)from.m_123343_() + 0.5));
            for (GraphLinkSegment segment : this.segments) {
                Vector3 last = points.getLast();
                switch (segment.dir()) {
                    case 0: {
                        points.add(last.copy().add(0.0, (double)(-segment.length()), 0.0));
                        break;
                    }
                    case 1: {
                        points.add(last.copy().add(0.0, (double)segment.length(), 0.0));
                        break;
                    }
                    case 2: {
                        points.add(last.copy().add(0.0, 0.0, (double)(-segment.length())));
                        break;
                    }
                    case 3: {
                        points.add(last.copy().add(0.0, 0.0, (double)segment.length()));
                        break;
                    }
                    case 4: {
                        points.add(last.copy().add((double)(-segment.length()), 0.0, 0.0));
                        break;
                    }
                    case 5: {
                        points.add(last.copy().add((double)segment.length(), 0.0, 0.0));
                    }
                }
            }
            return points;
        }
    }
}

