/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.graphs;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import mrtjp.projectred.expansion.graphs.GraphNode;
import mrtjp.projectred.expansion.graphs.GraphRoute;

public class GraphRouteTable {
    private final HashMap<GraphNode, List<GraphRoute>> table;
    private final HashMap<Integer, List<GraphRoute>> directions;
    private final List<GraphNode> destinations;
    private final List<GraphRoute> routes;

    public GraphRouteTable(HashMap<GraphNode, List<GraphRoute>> table, HashMap<Integer, List<GraphRoute>> directions, List<GraphNode> destinations, List<GraphRoute> routes) {
        this.table = table;
        this.directions = directions;
        this.destinations = destinations;
        this.routes = routes;
    }

    public List<GraphRoute> getPathsTo(GraphNode destination) {
        return this.table.get(destination);
    }

    public Iterator<GraphRoute> routeIteratorInDirection(int direction) {
        if (!this.directions.containsKey(direction)) {
            return Collections.emptyIterator();
        }
        return this.directions.get(direction).iterator();
    }

    public List<GraphNode> getDestinations() {
        return this.destinations;
    }

    public Iterator<GraphRoute> routeIterator() {
        return this.routes.iterator();
    }
}

