/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.inventory.container;

import codechicken.lib.inventory.container.ICCLContainerFactory;
import mrtjp.projectred.core.inventory.container.BasePoweredBlockEntityMenu;
import mrtjp.projectred.core.inventory.container.SimpleDataSlot;
import mrtjp.projectred.core.tile.BasePoweredBlockEntity;
import mrtjp.projectred.expansion.init.ExpansionMenus;
import mrtjp.projectred.expansion.item.IChargable;
import mrtjp.projectred.expansion.tile.ChargingBenchBlockEntity;
import mrtjp.projectred.lib.InventoryLib;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ChargingBenchMenu
extends BasePoweredBlockEntityMenu {
    public static final ICCLContainerFactory<ChargingBenchMenu> FACTORY = (windowId, inventory, packet) -> {
        BlockEntity tile = inventory.f_35978_.m_9236_().m_7702_(packet.readPos());
        if (!(tile instanceof ChargingBenchBlockEntity)) {
            return null;
        }
        return new ChargingBenchMenu(inventory, (ChargingBenchBlockEntity)tile, windowId);
    };
    private final Inventory playerInventory;
    private final ChargingBenchBlockEntity tile;
    protected int powerStored = 0;

    public ChargingBenchMenu(Inventory inventory, ChargingBenchBlockEntity tile, int windowId) {
        super((MenuType)ExpansionMenus.CHARGING_BENCH_MENU.get(), windowId, (BasePoweredBlockEntity)tile);
        this.playerInventory = inventory;
        this.tile = tile;
        InventoryLib.addPlayerInventory((Inventory)inventory, (int)8, (int)101, x$0 -> this.m_38897_((Slot)x$0));
        this.addChargingBenchInventory();
        this.m_38895_((DataSlot)new SimpleDataSlot(tile::getPowerStored, value -> {
            this.powerStored = value;
        }));
    }

    private void addChargingBenchInventory() {
        InventoryLib.addInventory((Container)this.tile.getInventory(), (int)0, (int)88, (int)17, (int)4, (int)2, ChargeableItemSlot::new, x$0 -> this.m_38897_((Slot)x$0));
        InventoryLib.addInventory((Container)this.tile.getInventory(), (int)8, (int)88, (int)57, (int)4, (int)2, ChargeableItemSlot::new, x$0 -> this.m_38897_((Slot)x$0));
    }

    public boolean m_6875_(Player pPlayer) {
        return Container.m_272074_((BlockEntity)this.tile, (Player)pPlayer);
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = slot.m_7993_();
        ItemStack originalStack = stack.m_41777_();
        if (this.isChargingStorage(slotIndex) || this.isFullChargeStorage(slotIndex) ? !this.moveToEntireInventory(stack, true) : (stack.m_41720_() instanceof IChargable ? !this.moveToChargingStorage(stack, false) : (this.isPlayerInventory(slotIndex) ? !this.moveToHotbar(stack, false) : this.isHotbar(slotIndex) && !this.moveToPlayerInventory(stack, false)))) {
            return ItemStack.f_41583_;
        }
        if (stack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        if (stack.m_41613_() == originalStack.m_41613_()) {
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, stack);
        return originalStack;
    }

    public int getPowerStoredScaled(int scale) {
        return Math.min(scale, scale * this.powerStored / this.tile.getMaxStorage());
    }

    public boolean isPowerStorageFull() {
        return this.powerStored == this.tile.getMaxStorage();
    }

    public boolean isStorageCharging() {
        return this.condCharge > this.tile.getConductorUpperChargeTarget() && this.powerStored < this.tile.getMaxStorage();
    }

    public boolean areItemsCharging() {
        if (this.powerStored == 0) {
            return false;
        }
        for (int i = 0; i < 8; ++i) {
            ItemStack stack = this.tile.getInventory().m_8020_(i);
            if (!(stack.m_41720_() instanceof IChargable) || ((IChargable)stack.m_41720_()).isFullyCharged(stack)) continue;
            return true;
        }
        return false;
    }

    private boolean isPlayerInventory(int slotIndex) {
        return slotIndex >= 0 && slotIndex < 27;
    }

    private boolean isHotbar(int slotIndex) {
        return slotIndex >= 27 && slotIndex < 36;
    }

    private boolean isChargingStorage(int slotIndex) {
        return slotIndex >= 36 && slotIndex < 44;
    }

    private boolean isFullChargeStorage(int slotIndex) {
        return slotIndex >= 44 && slotIndex < 52;
    }

    private boolean moveToPlayerInventory(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 0, 27, reverse);
    }

    private boolean moveToHotbar(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 27, 36, reverse);
    }

    private boolean moveToEntireInventory(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 0, 36, reverse);
    }

    private boolean moveToChargingStorage(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 36, 44, reverse);
    }

    private boolean moveToFullStorage(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 44, 52, reverse);
    }

    private static class ChargeableItemSlot
    extends Slot {
        public ChargeableItemSlot(Container inventory, int slot, int x, int y) {
            super(inventory, slot, x, y);
        }

        public boolean m_5857_(ItemStack stack) {
            return stack.m_41720_() instanceof IChargable;
        }
    }
}

