/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.expansion.tile;

import codechicken.lib.util.ItemUtils;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.tile.RedstoneConnector;
import java.util.Objects;
import mrtjp.projectred.core.CenterLookup;
import mrtjp.projectred.core.tile.ProjectRedBlockEntity;
import mrtjp.projectred.expansion.part.PneumaticTubePayload;
import mrtjp.projectred.expansion.pneumatics.PneumaticQueue;
import mrtjp.projectred.expansion.pneumatics.PneumaticTransportContainer;
import mrtjp.projectred.expansion.pneumatics.PneumaticTransportDevice;
import mrtjp.projectred.expansion.pneumatics.PneumaticTransportMode;
import mrtjp.projectred.expansion.tile.BaseDeviceBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class BasePneumaticDeviceBlockEntity
extends BaseDeviceBlockEntity
implements PneumaticTransportDevice,
RedstoneConnector {
    protected final PneumaticQueue itemQueue = new PneumaticQueue();

    public BasePneumaticDeviceBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void saveToNBT(CompoundTag tag) {
        super.saveToNBT(tag);
        CompoundTag queueTag = new CompoundTag();
        this.itemQueue.save(queueTag);
        tag.m_128365_("queue", (Tag)queueTag);
    }

    @Override
    public void loadFromNBT(CompoundTag tag) {
        super.loadFromNBT(tag);
        this.itemQueue.load(tag.m_128469_("queue"));
    }

    public void onBlockRemoved() {
        super.onBlockRemoved();
        while (!this.itemQueue.isEmpty()) {
            ProjectRedBlockEntity.dropItem((ItemStack)Objects.requireNonNull(this.itemQueue.poll()).getItemStack(), (Level)this.m_58904_(), (Vector3)Vector3.fromTileCenter((BlockEntity)this));
        }
    }

    @Override
    protected void onScheduledTick() {
        super.onScheduledTick();
        if (!this.m_58904_().f_46443_) {
            this.exportQueue();
            this.scheduleTick(this.itemQueue.isEmpty() ? 4 : 16);
        }
    }

    protected void exportQueue() {
        while (!this.itemQueue.isEmpty()) {
            PneumaticTubePayload payload = this.itemQueue.poll();
            if (!this.exportToTube(payload) && !this.exportToItemEntity(payload)) {
                this.itemQueue.addBackStuffed(payload);
            }
            if (!this.itemQueue.isBackStuffed()) continue;
            break;
        }
    }

    protected boolean exportToTube(PneumaticTubePayload payload) {
        CenterLookup lookup = CenterLookup.lookupStraightCenter((Level)this.m_58904_(), (BlockPos)this.m_58899_(), (int)this.side);
        MultiPart multiPart = lookup.part;
        if (!(multiPart instanceof PneumaticTransportContainer)) {
            return false;
        }
        PneumaticTransportContainer ptc = (PneumaticTransportContainer)multiPart;
        return ptc.insertPayload(lookup.otherDirection, payload);
    }

    protected boolean exportToItemEntity(PneumaticTubePayload payload) {
        CenterLookup lookup = CenterLookup.lookupStraightCenter((Level)this.m_58904_(), (BlockPos)this.m_58899_(), (int)this.side);
        if (!lookup.state.m_60795_()) {
            return false;
        }
        ItemUtils.ejectItem((Level)this.m_58904_(), (BlockPos)this.m_58899_().m_121945_(Direction.values()[this.side]), (ItemStack)payload.getItemStack(), (Direction)Direction.values()[this.side]);
        return true;
    }

    @Override
    public boolean canConnectTube(int s) {
        return s == this.side || s == (this.side ^ 1);
    }

    @Override
    public boolean canAcceptPayload(int s, PneumaticTubePayload payload, PneumaticTransportMode mode) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case PneumaticTransportMode.PASSIVE_NORMAL -> {
                if (s == (this.side ^ 1) && !this.powered && this.itemQueue.isEmpty()) {
                    yield true;
                }
                yield false;
            }
            case PneumaticTransportMode.PASSIVE_BACKSTUFF -> s == this.side;
        };
    }

    @Override
    public boolean insertPayload(int s, PneumaticTubePayload payload) {
        if (this.canAcceptPayload(s, payload, PneumaticTransportMode.PASSIVE_NORMAL)) {
            this.itemQueue.add(payload);
            this.active = true;
            this.m_6596_();
            this.pushBlockState();
            this.scheduleTick(4);
            this.exportQueue();
            return true;
        }
        if (this.canAcceptPayload(s, payload, PneumaticTransportMode.PASSIVE_BACKSTUFF)) {
            this.itemQueue.addBackStuffed(payload);
            this.active = true;
            this.m_6596_();
            this.pushBlockState();
            this.scheduleTick(4);
            return true;
        }
        return false;
    }

    @Override
    protected boolean shouldStayActive() {
        return !this.itemQueue.isEmpty();
    }

    public int getConnectionMask(int side) {
        return (side ^ 1) == this.side ? 0 : 31;
    }

    public int weakPowerLevel(int side, int mask) {
        return 0;
    }
}

