/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.environmental;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsutility.modules.environmental.blocks.EnvironmentalControllerTileEntity;
import mcjty.rftoolsutility.modules.environmental.modules.EnvironmentModule;
import mcjty.rftoolsutility.modules.environmental.modules.PeacefulEModule;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.server.ServerLifecycleHooks;

public class PeacefulAreaManager {
    private static final Map<GlobalPos, PeacefulArea> areas = new HashMap<GlobalPos, PeacefulArea>();

    public static void markArea(GlobalPos coordinate, int radius, int miny, int maxy) {
        if (areas.containsKey(coordinate)) {
            areas.get(coordinate).touch().setArea(radius, miny, maxy);
        } else {
            PeacefulArea area = new PeacefulArea(radius, miny, maxy);
            areas.put(coordinate, area);
        }
    }

    public static boolean isPeaceful(GlobalPos coordinate) {
        if (areas.isEmpty()) {
            return false;
        }
        ArrayList<GlobalPos> toRemove = new ArrayList<GlobalPos>();
        boolean peaceful = false;
        long curtime = System.currentTimeMillis() - 10000L;
        for (Map.Entry<GlobalPos, PeacefulArea> entry : areas.entrySet()) {
            BlockPos c;
            ServerLevel world;
            GlobalPos entryCoordinate;
            PeacefulArea area = entry.getValue();
            if (area.in(coordinate, entryCoordinate = entry.getKey())) {
                peaceful = true;
            }
            if (area.getLastTouched() >= curtime || (world = ServerLifecycleHooks.getCurrentServer().m_129880_(entryCoordinate.m_122640_())) == null || !LevelTools.isLoaded((Level)world, (BlockPos)(c = entryCoordinate.m_122646_()))) continue;
            boolean removeArea = true;
            BlockEntity te = world.m_7702_(c);
            if (te instanceof EnvironmentalControllerTileEntity) {
                EnvironmentalControllerTileEntity controller = (EnvironmentalControllerTileEntity)te;
                for (EnvironmentModule module : controller.getEnvironmentModules()) {
                    if (!(module instanceof PeacefulEModule) || !((PeacefulEModule)module).isActive()) continue;
                    removeArea = false;
                    break;
                }
            }
            if (!removeArea) continue;
            toRemove.add(entryCoordinate);
        }
        for (GlobalPos globalCoordinate : toRemove) {
            areas.remove(globalCoordinate);
        }
        return peaceful;
    }

    public static class PeacefulArea {
        private float sqradius;
        private int miny;
        private int maxy;
        private long lastTouched;

        public PeacefulArea(float radius, int miny, int maxy) {
            this.sqradius = radius * radius;
            this.miny = miny;
            this.maxy = maxy;
            this.touch();
        }

        public PeacefulArea setArea(float radius, int miny, int maxy) {
            this.sqradius = radius * radius;
            this.miny = miny;
            this.maxy = maxy;
            return this;
        }

        public String toString() {
            return "PeacefulArea{sqradius=" + this.sqradius + ", miny=" + this.miny + ", maxy=" + this.maxy + ", lastTouched=" + this.lastTouched + "}";
        }

        public long getLastTouched() {
            return this.lastTouched;
        }

        public PeacefulArea touch() {
            this.lastTouched = System.currentTimeMillis();
            return this;
        }

        public boolean in(GlobalPos coordinate, GlobalPos thisCoordinate) {
            double pz;
            if (!coordinate.m_122640_().equals((Object)thisCoordinate.m_122640_())) {
                return false;
            }
            double py = coordinate.m_122646_().m_123342_();
            if (py < (double)this.miny || py > (double)this.maxy) {
                return false;
            }
            double px = coordinate.m_122646_().m_123341_() - thisCoordinate.m_122646_().m_123341_();
            double sqdist = px * px + (pz = (double)(coordinate.m_122646_().m_123343_() - thisCoordinate.m_122646_().m_123343_())) * pz;
            return sqdist < (double)this.sqradius;
        }
    }
}

