/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Type;
import mcjty.rftoolsutility.modules.logic.LogicBlockModule;
import mcjty.rftoolsutility.modules.logic.blocks.RedstoneChannelTileEntity;
import mcjty.rftoolsutility.modules.logic.network.PacketSetChannelName;
import mcjty.rftoolsutility.modules.logic.tools.RedstoneChannels;
import mcjty.rftoolsutility.setup.RFToolsUtilityMessages;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;

public class RedstoneTransmitterTileEntity
extends RedstoneChannelTileEntity {
    private int prevIn = -1;
    private String channelName;
    @GuiValue
    public static final Value<?, String> VALUE_NAME = Value.create((String)"name", (Type)Type.STRING, RedstoneTransmitterTileEntity::getChannelName, RedstoneTransmitterTileEntity::setChannelName);
    @Cap(type=CapType.CONTAINER)
    private LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Redstone Receiver").containerSupplier(DefaultContainerProvider.empty(LogicBlockModule.CONTAINER_REDSTONE_TRANSMITTER, (GenericTileEntity)this)).setupSync((GenericTileEntity)this));

    public void setChannelName(String v) {
        if (this.f_58857_.f_46443_) {
            this.channelName = v;
            RFToolsUtilityMessages.sendToServer(PacketSetChannelName.create(this.f_58858_, this.channelName));
        } else {
            if (this.channel == -1) {
                this.getChannel(true);
            }
            RedstoneChannels channels = RedstoneChannels.getChannels(this.f_58857_);
            RedstoneChannels.RedstoneChannel ch = channels.getOrCreateChannel(this.channel);
            ch.setName(v);
            channels.m_77762_();
            this.m_6596_();
        }
    }

    private String getChannelName() {
        if (this.f_58857_.f_46443_) {
            return this.channelName;
        }
        if (this.channel == -1) {
            return "";
        }
        RedstoneChannels channels = RedstoneChannels.getChannels(this.f_58857_);
        RedstoneChannels.RedstoneChannel ch = channels.getOrCreateChannel(this.channel);
        return ch.getName();
    }

    public RedstoneTransmitterTileEntity(BlockPos pos, BlockState state) {
        super(LogicBlockModule.TYPE_REDSTONE_TRANSMITTER.get(), pos, state);
    }

    public void saveClientDataToNBT(CompoundTag tagCompound) {
        tagCompound.m_128359_("channelName", this.getChannelName());
    }

    public void loadClientDataFromNBT(CompoundTag tagCompound) {
        this.channelName = tagCompound.m_128461_("channelName");
    }

    @Override
    public void setChannel(int channel) {
        super.setChannel(channel);
        this.update();
    }

    public void update() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.channel == -1) {
            return;
        }
        if (this.powerLevel != this.prevIn) {
            this.prevIn = this.powerLevel;
            this.m_6596_();
            RedstoneChannels channels = RedstoneChannels.getChannels(this.f_58857_);
            RedstoneChannels.RedstoneChannel ch = channels.getOrCreateChannel(this.channel);
            ch.setValue(this.powerLevel);
            channels.save();
        }
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        this.prevIn = tagCompound.m_128425_("prevIn", 3) ? tagCompound.m_128451_("prevIn") : (tagCompound.m_128471_("prevIn") ? 15 : 0);
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        super.m_183515_(tagCompound);
        tagCompound.m_128405_("prevIn", this.prevIn);
    }
}

