/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.network;

import mcjty.lib.network.CustomPacketPayload;
import mcjty.lib.network.PlayPayloadContext;
import mcjty.rftoolsutility.modules.logic.items.RedstoneInformationContainer;
import mcjty.rftoolsutility.modules.logic.items.RedstoneInformationItem;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public record PacketRemoveChannel(Integer channel) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("rftoolsutility", "removechannel");

    public static PacketRemoveChannel create(FriendlyByteBuf buf) {
        return new PacketRemoveChannel(buf.readInt());
    }

    public static PacketRemoveChannel create(int channel) {
        return new PacketRemoveChannel(channel);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.channel.intValue());
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> ctx.player().ifPresent(playerEntity -> {
            ItemStack informationItem = RedstoneInformationContainer.getRedstoneInformationItem(playerEntity);
            if (informationItem.m_41720_() instanceof RedstoneInformationItem) {
                RedstoneInformationItem.removeChannel(informationItem, this.channel);
            }
        }));
    }
}

