/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.blocks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.module.DefaultModuleSupport;
import mcjty.lib.api.module.IModuleSupport;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ResultCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.network.Networking;
import mcjty.lib.network.PacketServerCommandTyped;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsbase.api.screens.IClientScreenModule;
import mcjty.rftoolsbase.api.screens.IModuleGuiBuilder;
import mcjty.rftoolsbase.api.screens.IModuleProvider;
import mcjty.rftoolsbase.api.screens.IScreenDataHelper;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.screens.IScreenModuleUpdater;
import mcjty.rftoolsbase.api.screens.ITooltipInfo;
import mcjty.rftoolsbase.api.screens.data.IModuleData;
import mcjty.rftoolsbase.api.screens.data.IModuleDataBoolean;
import mcjty.rftoolsbase.api.screens.data.IModuleDataContents;
import mcjty.rftoolsbase.api.screens.data.IModuleDataInteger;
import mcjty.rftoolsbase.api.screens.data.IModuleDataString;
import mcjty.rftoolsutility.modules.screen.NbtSanitizerModuleGuiBuilder;
import mcjty.rftoolsutility.modules.screen.ScreenModule;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenBlock;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenContainer;
import mcjty.rftoolsutility.modules.screen.data.ModuleDataBoolean;
import mcjty.rftoolsutility.modules.screen.data.ModuleDataInteger;
import mcjty.rftoolsutility.modules.screen.data.ModuleDataString;
import mcjty.rftoolsutility.modules.screen.modules.ComputerScreenModule;
import mcjty.rftoolsutility.modules.screen.modules.ScreenModuleHelper;
import mcjty.rftoolsutility.modules.screen.modulesclient.TextClientScreenModule;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.Lazy;

public class ScreenTileEntity
extends TickingTileEntity {
    public List<String> infoReceived = Collections.emptyList();
    @GuiValue
    private boolean bright = false;
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, ScreenContainer.CONTAINER_FACTORY).onUpdate((slot, stack) -> this.resetModules()).build();
    @Cap(type=CapType.CONTAINER)
    private final Lazy<MenuProvider> screenHandler = Lazy.of(() -> new DefaultContainerProvider("Screen").containerSupplier((windowId, player) -> ScreenContainer.create(windowId, this.m_58899_(), (GenericTileEntity)this, player)).itemHandler(() -> this.items).setupSync((GenericTileEntity)this));
    @Cap(type=CapType.MODULE)
    private final IModuleSupport moduleSupportHandler = new DefaultModuleSupport(0, 10){

        public boolean isModule(ItemStack itemStack) {
            return itemStack.m_41720_() instanceof IModuleProvider;
        }
    };
    public static final Map<GlobalPos, Map<Integer, IModuleData>> screenData = new HashMap<GlobalPos, Map<Integer, IModuleData>>();
    private List<IClientScreenModule<?>> clientScreenModules = null;
    private final Map<String, List<ComputerScreenModule>> computerModules = new HashMap<String, List<ComputerScreenModule>>();
    private ResourceKey<Level> dummyType = null;
    private boolean needsServerData = false;
    private boolean showHelp = true;
    private boolean powerOn = false;
    private boolean connected = false;
    private int size = 0;
    private boolean transparent = false;
    private int color = 0;
    private int trueTypeMode = 0;
    private int hoveringModule = -1;
    private int hoveringX = -1;
    private int hoveringY = -1;
    public static final int SIZE_NORMAL = 0;
    public static final int SIZE_LARGE = 1;
    public static final int SIZE_HUGE = 2;
    private List<IScreenModule<?>> screenModules = null;
    private Map<ActivatedModule, ModuleTicker> clickedModules = new HashMap<ActivatedModule, ModuleTicker>();
    private int totalRfPerTick = 0;
    private boolean controllerNeededInCreative = false;
    public long lastTime = 0L;
    private static List<IClientScreenModule<?>> helpingScreenModules = null;
    private final IScreenDataHelper screenDataHelper = new IScreenDataHelper(){

        public IModuleDataInteger createInteger(int i) {
            return new ModuleDataInteger(i);
        }

        public IModuleDataBoolean createBoolean(boolean b) {
            return new ModuleDataBoolean(b);
        }

        public IModuleDataString createString(String b) {
            return new ModuleDataString(b);
        }

        public IModuleDataContents createContents(long contents, long maxContents, long lastPerTick) {
            return new ScreenModuleHelper.ModuleDataContents(contents, maxContents, lastPerTick);
        }
    };
    public static final Key<Integer> PARAM_X = new Key("x", Type.INTEGER);
    public static final Key<Integer> PARAM_Y = new Key("y", Type.INTEGER);
    public static final Key<Integer> PARAM_MODULE = new Key("module", Type.INTEGER);
    public static final Key<Integer> PARAM_TRUETYPE = new Key("truetype", Type.INTEGER);
    @ServerCommand
    public static final Command<?> CMD_CLICK = Command.create((String)"screen.click", (te, player, params) -> te.hitScreenServer(player, (Integer)params.get(PARAM_X), (Integer)params.get(PARAM_Y), (Integer)params.get(PARAM_MODULE)));
    @ServerCommand
    public static final Command<?> CMD_HOVER = Command.create((String)"screen.hover", (te, player, params) -> {
        te.hoveringX = (Integer)params.get(PARAM_X);
        te.hoveringY = (Integer)params.get(PARAM_Y);
        te.hoveringModule = (Integer)params.get(PARAM_MODULE);
    });
    @ServerCommand
    public static final Command<?> CMD_SETTRUETYPE = Command.create((String)"screen.setTruetype", (te, player, params) -> te.setTrueTypeMode((Integer)params.get(PARAM_TRUETYPE)));
    public static final Key<List<String>> PARAM_INFO = new Key("info", Type.STRING_LIST);
    @ServerCommand
    public static final ResultCommand<?> CMD_SCREEN_INFO = ResultCommand.create((String)"getScreenInfo", (te, player, params) -> {
        IScreenModule<?> module = te.getHoveringModule((Integer)params.get(PARAM_MODULE));
        List info = Collections.emptyList();
        if (module instanceof ITooltipInfo) {
            info = ((ITooltipInfo)module).getInfo(te.f_58857_, ((Integer)params.get(PARAM_X)).intValue(), ((Integer)params.get(PARAM_Y)).intValue());
        }
        return TypedMap.builder().put(PARAM_INFO, info).build();
    }, (te, player, params) -> {
        te.infoReceived = (List)params.get(PARAM_INFO);
    });

    public ScreenTileEntity(BlockPos pos, BlockState state) {
        super(ScreenModule.TYPE_SCREEN.get(), pos, state);
    }

    public ScreenTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public ScreenTileEntity(ResourceKey<Level> world, BlockPos pos) {
        this(pos, null);
        this.dummyType = world;
    }

    public ScreenTileEntity(BlockEntityType<?> type, ResourceKey<Level> world, BlockPos pos) {
        this(type, pos, null);
        this.dummyType = world;
    }

    public boolean isDummy() {
        return this.dummyType != null;
    }

    public ResourceKey<Level> getDimension() {
        if (this.dummyType != null) {
            return this.dummyType;
        }
        return super.getDimension();
    }

    public AABB getRenderBoundingBox() {
        int xCoord = this.m_58899_().m_123341_();
        int yCoord = this.m_58899_().m_123342_();
        int zCoord = this.m_58899_().m_123343_();
        return new AABB((double)(xCoord - this.size - 1), (double)(yCoord - this.size - 1), (double)(zCoord - this.size - 1), (double)(xCoord + this.size + 1), (double)(yCoord + this.size + 1), (double)(zCoord + this.size + 1));
    }

    protected void tickClient() {
        this.tickMe();
    }

    public void tickMe() {
        if (this.clickedModules.isEmpty()) {
            return;
        }
        HashMap<ActivatedModule, ModuleTicker> newClickedModules = new HashMap<ActivatedModule, ModuleTicker>();
        for (Map.Entry<ActivatedModule, ModuleTicker> cm : this.clickedModules.entrySet()) {
            --cm.getValue().ticks;
            ActivatedModule activatedModule = cm.getKey();
            if (cm.getValue().ticks > 0) {
                newClickedModules.put(activatedModule, cm.getValue());
                continue;
            }
            List<IClientScreenModule<?>> modules = this.getClientScreenModules();
            if (activatedModule.module >= modules.size()) continue;
            modules.get(activatedModule.module).mouseClick(this.f_58857_, activatedModule.x, activatedModule.y, false);
        }
        this.clickedModules = newClickedModules;
    }

    protected void tickServer() {
        if (this.clickedModules.isEmpty()) {
            return;
        }
        HashMap<ActivatedModule, ModuleTicker> newClickedModules = new HashMap<ActivatedModule, ModuleTicker>();
        for (Map.Entry<ActivatedModule, ModuleTicker> cm : this.clickedModules.entrySet()) {
            CompoundTag newCompound;
            --cm.getValue().ticks;
            ActivatedModule activatedModule = cm.getKey();
            if (cm.getValue().ticks > 0) {
                newClickedModules.put(activatedModule, cm.getValue());
                continue;
            }
            List<IScreenModule<?>> modules = this.getScreenModules();
            if (activatedModule.module >= modules.size()) continue;
            ItemStack itemStack = this.items.getStackInSlot(activatedModule.module);
            IScreenModule<?> module = modules.get(activatedModule.module);
            module.mouseClick(this.f_58857_, activatedModule.x, activatedModule.y, false, null);
            if (!(module instanceof IScreenModuleUpdater) || (newCompound = ((IScreenModuleUpdater)module).update(itemStack.m_41783_(), this.f_58857_, null)) == null) continue;
            itemStack.m_41751_(newCompound);
            this.markDirtyClient();
        }
        this.clickedModules = newClickedModules;
    }

    private void resetModules() {
        this.clientScreenModules = null;
        this.screenModules = null;
        this.clickedModules.clear();
        this.showHelp = true;
        this.computerModules.clear();
    }

    private boolean isActivated(int index) {
        for (ActivatedModule module : this.clickedModules.keySet()) {
            if (module.module != index) continue;
            return true;
        }
        return false;
    }

    public void focusModuleClient(double hitX, double hitY, double hitZ, Direction side, Direction horizontalFacing) {
        int module;
        int y;
        int x;
        ModuleRaytraceResult result = this.getHitModule(hitX, hitY, hitZ, side, horizontalFacing, this.size);
        if (result == null) {
            x = -1;
            y = -1;
            module = -1;
        } else {
            x = result.x();
            y = result.y() - result.currenty();
            module = result.moduleIndex();
        }
        if (x != this.hoveringX || y != this.hoveringY || module != this.hoveringModule) {
            PacketServerCommandTyped packet = PacketServerCommandTyped.create((BlockPos)this.m_58899_(), this.getDimension(), (String)CMD_HOVER.name(), (TypedMap)TypedMap.builder().put(PARAM_X, (Object)x).put(PARAM_Y, (Object)y).put(PARAM_MODULE, (Object)module).build());
            Networking.sendToServer((Object)packet);
            this.hoveringX = x;
            this.hoveringY = y;
            this.hoveringModule = module;
        }
    }

    public void hitScreenClient(double hitX, double hitY, double hitZ, Direction side, Direction horizontalFacing) {
        ModuleRaytraceResult result = this.getHitModule(hitX, hitY, hitZ, side, horizontalFacing, this.size);
        if (result == null) {
            return;
        }
        this.hitScreenClient(result);
    }

    public void hitScreenClient(ModuleRaytraceResult result) {
        List<IClientScreenModule<?>> modules = this.getClientScreenModules();
        int module = result.moduleIndex();
        if (this.isActivated(module)) {
            return;
        }
        modules.get(module).mouseClick(this.f_58857_, result.x(), result.y() - result.currenty(), true);
        this.clickedModules.put(new ActivatedModule(module, result.x(), result.y()), new ModuleTicker(3));
        PacketServerCommandTyped packet = PacketServerCommandTyped.create((BlockPos)this.m_58899_(), this.getDimension(), (String)CMD_CLICK.name(), (TypedMap)TypedMap.builder().put(PARAM_X, (Object)result.x()).put(PARAM_Y, (Object)(result.y() - result.currenty())).put(PARAM_MODULE, (Object)module).build());
        Networking.sendToServer((Object)packet);
    }

    public ModuleRaytraceResult getHitModule(double hitX, double hitY, double hitZ, Direction side, Direction horizontalFacing, int size) {
        float factor = (float)size + 1.0f;
        float dx = 0.0f;
        float dy = 0.0f;
        switch (side) {
            case NORTH: {
                dx = (float)((1.0 - hitX) / (double)factor);
                dy = (float)((1.0 - hitY) / (double)factor);
                break;
            }
            case SOUTH: {
                dx = (float)(hitX / (double)factor);
                dy = (float)((1.0 - hitY) / (double)factor);
                break;
            }
            case WEST: {
                dx = (float)(hitZ / (double)factor);
                dy = (float)((1.0 - hitY) / (double)factor);
                break;
            }
            case EAST: {
                dx = (float)((1.0 - hitZ) / (double)factor);
                dy = (float)((1.0 - hitY) / (double)factor);
                break;
            }
            case UP: {
                switch (horizontalFacing) {
                    case NORTH: {
                        dx = (float)((1.0 - hitX) / (double)factor);
                        dy = (float)((1.0 - hitZ) / (double)factor);
                        break;
                    }
                    case SOUTH: {
                        dx = (float)(hitX / (double)factor);
                        dy = (float)(hitZ / (double)factor);
                        break;
                    }
                    case WEST: {
                        dx = (float)(hitZ / (double)factor);
                        dy = (float)((1.0 - hitX) / (double)factor);
                        break;
                    }
                    case EAST: {
                        dx = (float)((1.0 - hitZ) / (double)factor);
                        dy = (float)(hitX / (double)factor);
                    }
                }
                break;
            }
            case DOWN: {
                switch (horizontalFacing) {
                    case NORTH: {
                        dx = (float)((1.0 - hitX) / (double)factor);
                        dy = (float)(hitZ / (double)factor);
                        break;
                    }
                    case SOUTH: {
                        dx = (float)(hitX / (double)factor);
                        dy = (float)((1.0 - hitZ) / (double)factor);
                        break;
                    }
                    case WEST: {
                        dx = (float)(hitZ / (double)factor);
                        dy = (float)(hitX / (double)factor);
                        break;
                    }
                    case EAST: {
                        dx = (float)((1.0 - hitZ) / (double)factor);
                        dy = (float)((1.0 - hitX) / (double)factor);
                    }
                }
                break;
            }
            default: {
                return null;
            }
        }
        int x = (int)(dx * 128.0f);
        int y = (int)(dy * 128.0f);
        int currenty = 7;
        int moduleIndex = 0;
        List<IClientScreenModule<?>> clientScreenModules = this.getClientScreenModules();
        for (IClientScreenModule<?> module : clientScreenModules) {
            int height;
            if (module != null && currenty + (height = module.getHeight()) <= 124) {
                if (currenty <= y && y < currenty + height) break;
                currenty += height;
            }
            ++moduleIndex;
        }
        if (moduleIndex >= clientScreenModules.size()) {
            return null;
        }
        return new ModuleRaytraceResult(moduleIndex, x, y, currenty);
    }

    private void hitScreenServer(Player player, int x, int y, int module) {
        List<IScreenModule<?>> screenModules = this.getScreenModules();
        IScreenModule<?> screenModule = screenModules.get(module);
        if (screenModule != null) {
            IScreenModuleUpdater updater;
            CompoundTag newCompound;
            ItemStack itemStack = this.items.getStackInSlot(module);
            screenModule.mouseClick(this.f_58857_, x, y, true, player);
            if (screenModule instanceof IScreenModuleUpdater && (newCompound = (updater = (IScreenModuleUpdater)screenModule).update(itemStack.m_41783_(), this.f_58857_, player)) != null) {
                itemStack.m_41751_(newCompound);
                this.markDirtyClient();
            }
            this.clickedModules.put(new ActivatedModule(module, x, y), new ModuleTicker(5));
        }
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        this.powerOn = tagCompound.m_128471_("powerOn");
        this.connected = tagCompound.m_128471_("connected");
        this.totalRfPerTick = tagCompound.m_128451_("rfPerTick");
        this.controllerNeededInCreative = tagCompound.m_128471_("controllerNeededInCreative");
        this.readRestorableFromNBT(tagCompound);
    }

    public void readRestorableFromNBT(CompoundTag tagCompound) {
        this.resetModules();
        this.size = tagCompound.m_128441_("large") ? (tagCompound.m_128471_("large") ? 1 : 0) : tagCompound.m_128451_("size");
        this.transparent = tagCompound.m_128471_("transparent");
        this.color = tagCompound.m_128451_("color");
        this.bright = tagCompound.m_128471_("bright");
        this.trueTypeMode = tagCompound.m_128451_("truetype");
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        super.m_183515_(tagCompound);
        tagCompound.m_128379_("powerOn", this.powerOn);
        tagCompound.m_128379_("connected", this.connected);
        tagCompound.m_128405_("rfPerTick", this.totalRfPerTick);
        tagCompound.m_128379_("controllerNeededInCreative", this.controllerNeededInCreative);
        this.writeRestorableToNBT(tagCompound);
    }

    public void writeRestorableToNBT(CompoundTag tagCompound) {
        tagCompound.m_128405_("size", this.size);
        tagCompound.m_128379_("transparent", this.transparent);
        tagCompound.m_128405_("color", this.color);
        tagCompound.m_128379_("bright", this.bright);
        tagCompound.m_128405_("truetype", this.trueTypeMode);
    }

    public void saveClientDataToNBT(CompoundTag tagCompound) {
        this.writeRestorableToNBT(tagCompound);
        this.saveItemHandlerCap(tagCompound);
        tagCompound.m_128379_("powerOn", this.powerOn);
        tagCompound.m_128379_("connected", this.connected);
    }

    public void loadClientDataFromNBT(CompoundTag tagCompound) {
        this.powerOn = tagCompound.m_128471_("powerOn");
        this.connected = tagCompound.m_128471_("connected");
        this.readRestorableFromNBT(tagCompound);
        this.loadItemHandlerCap(tagCompound);
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
        this.m_6596_();
    }

    public void setSize(int size) {
        this.size = size;
        this.m_6596_();
    }

    public boolean isBright() {
        return this.bright;
    }

    public void setBright(boolean bright) {
        this.bright = bright;
        this.m_6596_();
    }

    public int getTrueTypeMode() {
        return this.trueTypeMode;
    }

    public void setTrueTypeMode(int trueTypeMode) {
        this.trueTypeMode = trueTypeMode;
        this.m_6596_();
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
        this.m_6596_();
    }

    public int getSize() {
        return this.size;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setPower(boolean power) {
        if (this.powerOn == power) {
            return;
        }
        this.powerOn = power;
        this.markDirtyClient();
    }

    public boolean isPowerOn() {
        return this.powerOn;
    }

    public boolean isRenderable() {
        if (this.powerOn) {
            return true;
        }
        if (this.isShowHelp()) {
            return true;
        }
        return this.isCreative();
    }

    public boolean isCreative() {
        return false;
    }

    public void setConnected(boolean c) {
        if (this.connected == c) {
            return;
        }
        this.connected = c;
        this.m_6596_();
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void updateModuleData(int slot, CompoundTag tagCompound) {
        ItemStack stack = this.items.getStackInSlot(slot);
        ScreenBlock.getModuleProvider(stack).ifPresent(moduleProvider -> {
            NbtSanitizerModuleGuiBuilder sanitizer = new NbtSanitizerModuleGuiBuilder(this.f_58857_, stack.m_41783_());
            moduleProvider.createGui((IModuleGuiBuilder)sanitizer);
            stack.m_41751_(sanitizer.sanitizeNbt(tagCompound));
            this.screenModules = null;
            this.clientScreenModules = null;
            this.computerModules.clear();
            this.markDirtyClient();
        });
    }

    public static List<IClientScreenModule<?>> getHelpingScreenModules() {
        if (helpingScreenModules == null) {
            helpingScreenModules = new ArrayList();
            ScreenTileEntity.addLine("Read me", 0x7799FF, true);
            ScreenTileEntity.addLine("", 0xFFFFFF, false);
            ScreenTileEntity.addLine("Sneak-right click for", 0xFFFFFF, false);
            ScreenTileEntity.addLine("GUI and insertion of", 0xFFFFFF, false);
            ScreenTileEntity.addLine("modules", 0xFFFFFF, false);
            ScreenTileEntity.addLine("", 0xFFFFFF, false);
            ScreenTileEntity.addLine("Use Screen Controller", 0xFFFFFF, false);
            ScreenTileEntity.addLine("to power screens", 0xFFFFFF, false);
            ScreenTileEntity.addLine("remotely", 0xFFFFFF, false);
        }
        return helpingScreenModules;
    }

    private static void addLine(String s, int color, boolean large) {
        TextClientScreenModule t1 = new TextClientScreenModule();
        t1.setLine(s);
        t1.setColor(color);
        t1.setLarge(large);
        helpingScreenModules.add(t1);
    }

    public List<IClientScreenModule<?>> getClientScreenModules() {
        if (this.clientScreenModules == null) {
            this.needsServerData = false;
            this.showHelp = true;
            this.clientScreenModules = new ArrayList();
            for (int i = 0; i < this.items.getSlots(); ++i) {
                ItemStack itemStack = this.items.getStackInSlot(i);
                if (!itemStack.m_41619_() && ScreenBlock.hasModuleProvider(itemStack)) {
                    ScreenBlock.getModuleProvider(itemStack).ifPresent(moduleProvider -> {
                        IClientScreenModule clientScreenModule;
                        try {
                            clientScreenModule = (IClientScreenModule)moduleProvider.getClientScreenModule().newInstance();
                        }
                        catch (IllegalAccessException | InstantiationException e) {
                            Logging.logError((String)"Internal error with screen modules!", (Throwable)e);
                            return;
                        }
                        clientScreenModule.setupFromNBT(itemStack.m_41783_(), this.getDimension(), this.m_58899_());
                        this.clientScreenModules.add(clientScreenModule);
                        if (clientScreenModule.needsServerData()) {
                            this.needsServerData = true;
                        }
                        this.showHelp = false;
                    });
                    continue;
                }
                this.clientScreenModules.add(null);
            }
        }
        return this.clientScreenModules;
    }

    public boolean isShowHelp() {
        return this.showHelp;
    }

    public boolean isNeedsServerData() {
        return this.needsServerData;
    }

    public int getTotalRfPerTick() {
        if (this.isCreative()) {
            return 0;
        }
        if (this.screenModules == null) {
            this.getScreenModules();
        }
        return this.totalRfPerTick;
    }

    public boolean isControllerNeeded() {
        if (!this.isCreative()) {
            return true;
        }
        if (this.screenModules == null) {
            this.getScreenModules();
        }
        return this.controllerNeededInCreative;
    }

    public List<IScreenModule<?>> getScreenModules() {
        if (this.screenModules == null) {
            this.totalRfPerTick = 0;
            this.controllerNeededInCreative = false;
            this.screenModules = new ArrayList();
            for (int i = 0; i < this.items.getSlots(); ++i) {
                ItemStack itemStack = this.items.getStackInSlot(i);
                if (!itemStack.m_41619_() && ScreenBlock.hasModuleProvider(itemStack)) {
                    ScreenBlock.getModuleProvider(itemStack).ifPresent(moduleProvider -> {
                        IScreenModule screenModule;
                        try {
                            screenModule = (IScreenModule)moduleProvider.getServerScreenModule().newInstance();
                        }
                        catch (IllegalAccessException | InstantiationException e) {
                            Logging.logError((String)"Internal error with screen modules!", (Throwable)e);
                            return;
                        }
                        screenModule.setupFromNBT(itemStack.m_41783_(), this.f_58857_.m_46472_(), this.m_58899_());
                        this.screenModules.add(screenModule);
                        this.totalRfPerTick += screenModule.getRfPerTick();
                        if (screenModule.needsController()) {
                            this.controllerNeededInCreative = true;
                        }
                        if (screenModule instanceof ComputerScreenModule) {
                            ComputerScreenModule computerScreenModule = (ComputerScreenModule)screenModule;
                            String tag = computerScreenModule.getTag();
                            if (!this.computerModules.containsKey(tag)) {
                                this.computerModules.put(tag, new ArrayList());
                            }
                            this.computerModules.get(tag).add(computerScreenModule);
                        }
                    });
                    continue;
                }
                this.screenModules.add(null);
            }
        }
        return this.screenModules;
    }

    public List<ComputerScreenModule> getComputerModules(String tag) {
        return this.computerModules.get(tag);
    }

    public Set<String> getTags() {
        return this.computerModules.keySet();
    }

    public Map<Integer, IModuleData> getScreenData(long millis) {
        HashMap<Integer, IModuleData> map = new HashMap<Integer, IModuleData>();
        List<IScreenModule<?>> screenModules = this.getScreenModules();
        int moduleIndex = 0;
        for (IScreenModule<?> module : screenModules) {
            IModuleData data;
            if (module != null && (data = module.getData(this.screenDataHelper, this.f_58857_, millis)) != null) {
                map.put(moduleIndex, data);
            }
            ++moduleIndex;
        }
        return map;
    }

    public IScreenModule<?> getHoveringModule() {
        return this.getHoveringModule(this.hoveringModule);
    }

    public IScreenModule<?> getHoveringModule(int hoveringModule) {
        if (hoveringModule == -1) {
            return null;
        }
        this.getScreenModules();
        if (hoveringModule >= 0 && hoveringModule < this.screenModules.size()) {
            return this.screenModules.get(hoveringModule);
        }
        return null;
    }

    public int getHoveringX() {
        return this.hoveringX;
    }

    public int getHoveringY() {
        return this.hoveringY;
    }

    private static class ModuleTicker {
        private int ticks;

        public ModuleTicker(int ticks) {
            this.ticks = ticks;
        }
    }

    private record ActivatedModule(int module, int x, int y) {
    }

    public record ModuleRaytraceResult(int moduleIndex, int x, int y, int currenty) {
    }
}

