/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.network;

import java.util.ArrayList;
import java.util.List;
import mcjty.lib.network.CustomPacketPayload;
import mcjty.lib.network.PlayPayloadContext;
import mcjty.rftoolsutility.modules.teleporter.client.GuiTeleportProbe;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestination;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinationClientInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public record PacketAllReceiversReady(List<TeleportDestinationClientInfo> destinationList = new ArrayList<TeleportDestinationClientInfo>()) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("rftoolsutility", "allreceiversready");

    public PacketAllReceiversReady(List<TeleportDestinationClientInfo> destinationList) {
        this.destinationList.addAll(destinationList);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.destinationList.size());
        for (TeleportDestination teleportDestination : this.destinationList) {
            teleportDestination.toBytes(buf);
        }
    }

    public ResourceLocation id() {
        return ID;
    }

    public static PacketAllReceiversReady create(FriendlyByteBuf buf) {
        int size = buf.readInt();
        ArrayList<TeleportDestinationClientInfo> destinationList = new ArrayList<TeleportDestinationClientInfo>(size);
        for (int i = 0; i < size; ++i) {
            destinationList.add(new TeleportDestinationClientInfo(buf));
        }
        return new PacketAllReceiversReady(destinationList);
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> GuiTeleportProbe.setReceivers(this.destinationList));
    }
}

