/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.fengine.assemble;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mrtjp.fengine.TileCoord;
import mrtjp.fengine.api.IPathFinderManifest;
import mrtjp.fengine.assemble.PathFinderNode;

public class PathFinderManifest {
    private final Map<TileCoord, ManifestEntry> manifestMap = new HashMap<TileCoord, ManifestEntry>();

    public void addInputPropagationTrail(int inputRegId, PathFinderNode node) {
        node.forEachPropagation((pos, inDir, inPort, outDir, outPort) -> {
            ManifestEntry entry = this.manifestMap.computeIfAbsent(pos, p -> new ManifestEntry());
            entry.addInputPropagation(inputRegId, inDir, inPort, outDir, outPort);
        });
    }

    public void addOutputPropagationTrail(int outputRegId, PathFinderNode node) {
        node.forEachPropagation((pos, inDir, inPort, outDir, outPort) -> {
            ManifestEntry entry = this.manifestMap.computeIfAbsent(pos, p -> new ManifestEntry());
            entry.addOutputPropagation(outputRegId, inDir, inPort, outDir, outPort);
        });
    }

    public ManifestEntry getManifest(TileCoord pos) {
        return this.manifestMap.getOrDefault(pos, ManifestEntry.EMPTY);
    }

    public void clear() {
        this.manifestMap.clear();
    }

    private static class PropagationMask {
        private int inputDirMask = 0;
        private int inputPortMask = 0;
        private int outputDirMask = 0;
        private int outputPortMask = 0;

        private PropagationMask() {
        }

        public void or(int inputDir, int inputPort, int outputDir, int outputPort) {
            this.inputDirMask |= 1 << inputDir;
            this.inputPortMask |= 1 << inputPort;
            this.outputDirMask |= 1 << outputDir;
            this.outputPortMask |= 1 << outputPort;
        }

        public boolean testMasks(int inputDirMask, int inputPortMask, int outputDirMask, int outputPortMask) {
            return (this.inputDirMask & inputDirMask) != 0 && (this.inputPortMask & inputPortMask) != 0 && (this.outputDirMask & outputDirMask) != 0 && (this.outputPortMask & outputPortMask) != 0;
        }
    }

    private static class ManifestEntry
    implements IPathFinderManifest {
        private static final ManifestEntry EMPTY = new ManifestEntry();
        private final Map<Integer, PropagationMask> inputRegisters = new HashMap<Integer, PropagationMask>();
        private final Map<Integer, PropagationMask> outputRegisters = new HashMap<Integer, PropagationMask>();

        private ManifestEntry() {
        }

        public void addInputPropagation(int inputReg, int inputDir, int inputPort, int outputDir, int outputPort) {
            PropagationMask mask = this.inputRegisters.computeIfAbsent(inputReg, r -> new PropagationMask());
            mask.or(inputDir, inputPort, outputDir, outputPort);
        }

        public void addOutputPropagation(int outputReg, int inputDir, int inputPort, int outputDir, int outputPort) {
            PropagationMask mask = this.outputRegisters.computeIfAbsent(outputReg, r -> new PropagationMask());
            mask.or(inputDir, inputPort, outputDir, outputPort);
        }

        @Override
        public Set<Integer> getInputRegisters() {
            return this.inputRegisters.keySet();
        }

        @Override
        public Set<Integer> getOutputRegisters() {
            return this.outputRegisters.keySet();
        }

        @Override
        public Set<Integer> getInputRegistersIntersectingMasks(int inputDirMask, int inputPortMask, int outputDirMask, int outputPortMask) {
            return this.inputRegisters.entrySet().stream().filter(e -> ((PropagationMask)e.getValue()).testMasks(inputDirMask, inputPortMask, outputDirMask, outputPortMask)).map(Map.Entry::getKey).collect(Collectors.toSet());
        }

        @Override
        public Set<Integer> getOutputRegistersIntersectingMasks(int inputDirMask, int inputPortMask, int outputDirMask, int outputPortMask) {
            return this.outputRegisters.entrySet().stream().filter(e -> ((PropagationMask)e.getValue()).testMasks(inputDirMask, inputPortMask, outputDirMask, outputPortMask)).map(Map.Entry::getKey).collect(Collectors.toSet());
        }
    }
}

