/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.fengine.assemble;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.function.Supplier;
import mrtjp.fengine.api.Stepper;

public class StepTree<Descriptor, Result>
implements Stepper {
    private final Stack<StepTreeNode> stack = new Stack();
    private final StepTreeEventReceiver<Descriptor, Result> receiver;
    private int stepsRemaining = 0;

    public StepTree(StepTreeEventReceiver<Descriptor, Result> receiver) {
        this.receiver = receiver;
        this.stack.push(new StepTreeNode());
    }

    public void addStep(Descriptor descriptor, Supplier<Result> task) {
        this.stack.peek().createChild(descriptor, task);
        ++this.stepsRemaining;
    }

    @Override
    public void stepOver() {
        if (this.stepsRemaining == 0) {
            return;
        }
        StepTreeNode target = this.stack.peek();
        if (target.isComplete()) {
            if (!target.isRoot()) {
                this.popAndSetExecuted();
            }
            return;
        }
        while (!target.isComplete()) {
            StepTreeNode head = this.stack.peek();
            if (!head.isComplete()) {
                StepTreeNode next = head.getNextChildToExecute();
                this.pushAndExecute(next);
                continue;
            }
            this.popAndSetExecuted();
        }
    }

    @Override
    public void stepIn() {
        if (this.stepsRemaining == 0) {
            return;
        }
        StepTreeNode head = this.stack.peek();
        if (head.isComplete()) {
            if (!head.isRoot()) {
                this.popAndSetExecuted();
            }
            return;
        }
        StepTreeNode next = head.getNextChildToExecute();
        this.pushAndExecute(next);
    }

    @Override
    public void stepOut() {
        if (this.stepsRemaining == 0) {
            return;
        }
        StepTreeNode head = this.stack.peek();
        if (!head.isComplete()) {
            this.stepOver();
        }
        if (!head.isRoot()) {
            this.popAndSetExecuted();
        }
    }

    @Override
    public int stepsRemaining() {
        return this.stepsRemaining;
    }

    private void pushAndExecute(StepTreeNode node) {
        this.stack.push(node);
        node.executeTask();
        --this.stepsRemaining;
    }

    private void popAndSetExecuted() {
        this.stack.pop();
        this.stack.peek().setNextChildExecuted();
    }

    public static interface StepTreeEventReceiver<Descriptor, Result> {
        public void onStepExecuted(List<Integer> var1, Descriptor var2, Result var3);

        public void onStepAdded(List<Integer> var1, Descriptor var2);
    }

    private class StepTreeNode {
        private final List<StepTreeNode> children = new ArrayList<StepTreeNode>();
        private int completedChildren = 0;
        private final Descriptor descriptor;
        private final List<Integer> treePath;
        private final Supplier<Result> task;
        boolean taskExecuted = false;

        public StepTreeNode(List<Integer> treePath, Descriptor descriptor, Supplier<Result> task) {
            this.treePath = treePath;
            this.descriptor = descriptor;
            this.task = task;
        }

        public StepTreeNode() {
            this(Collections.emptyList(), null, null);
            this.taskExecuted = true;
        }

        public boolean isRoot() {
            return this.treePath.isEmpty();
        }

        public void createChild(Descriptor descriptor, Supplier<Result> task) {
            ArrayList<Integer> childTreePath = new ArrayList<Integer>(this.treePath.size() + 1);
            childTreePath.addAll(this.treePath);
            childTreePath.add(this.children.size());
            StepTreeNode child = new StepTreeNode(childTreePath, descriptor, task);
            this.children.add(child);
            StepTree.this.receiver.onStepAdded(childTreePath, descriptor);
        }

        public StepTreeNode getNextChildToExecute() {
            return this.children.get(this.completedChildren);
        }

        public void setNextChildExecuted() {
            ++this.completedChildren;
        }

        public void executeTask() {
            if (this.taskExecuted) {
                throw new RuntimeException("Task already executed");
            }
            Object result = this.task.get();
            this.taskExecuted = true;
            StepTree.this.receiver.onStepExecuted(this.treePath, this.descriptor, result);
        }

        public boolean isComplete() {
            return this.taskExecuted && this.completedChildren == this.children.size();
        }
    }
}

