/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine.gates;

import mrtjp.fengine.simulate.ICGate;
import mrtjp.fengine.simulate.ICSimulation;
import mrtjp.projectred.fabrication.engine.gates.ICGateTileType;
import mrtjp.projectred.fabrication.engine.gates.SimpleGateTile;

public class NOTGateTile
extends SimpleGateTile {
    public NOTGateTile() {
        super(ICGateTileType.NOT);
    }

    @Override
    protected int redstoneOutputMask() {
        return ~((this.getShape() & 1) << 1 | (this.getShape() & 2) >> 1 | (this.getShape() & 4) << 1) & 0xB;
    }

    @Override
    protected int redstoneInputMask() {
        return 4;
    }

    @Override
    protected int interactMask() {
        return 11;
    }

    @Override
    protected int getDeadSides() {
        return 3;
    }

    @Override
    protected int rotationToDeadSideBit(int r) {
        return switch (r) {
            case 0 -> 2;
            case 1 -> 1;
            case 3 -> 4;
            default -> 0;
        };
    }

    @Override
    public ICGate createGate() {
        return new NOTGate();
    }

    public static class NOTGate
    implements ICGate {
        @Override
        public void compute(ICSimulation ic, int[] inputs, int[] outputs) {
            boolean isHigh = ic.getRegByteVal(inputs[0]) != 0;
            for (int i = 0; i < outputs.length; ++i) {
                ic.queueRegByteVal(outputs[i], isHigh ? (byte)0 : 1);
            }
        }
    }
}

